/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.campaign;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.CampaignLibraryNodeVisitor;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.FolderSupport;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;

@Entity
@PrimaryKeyJoinColumn(name="CLN_ID")
public class CampaignFolder
extends CampaignLibraryNode
implements Folder<CampaignLibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignLibrary.class);
    @Transient
    private final FolderSupport<CampaignLibraryNode, CampaignFolder> folderSupport = new FolderSupport(this);
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="CLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID")})
    private List<CampaignLibraryNode> content = new ArrayList<CampaignLibraryNode>();

    @Override
    public List<CampaignLibraryNode> getContent() {
        return this.content;
    }

    @Override
    public void accept(CampaignLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void removeContent(CampaignLibraryNode node) throws NullArgumentException {
        this.content.remove(node);
        this.content = new ArrayList<CampaignLibraryNode>(this.content);
        LOGGER.info(this.content.toString(), new Object[0]);
    }

    @Override
    public void addContent(CampaignLibraryNode node) {
        CampaignLibraryNode campaignLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignLibraryNode);
        this.folderSupport.addContent(node);
    }

    @Override
    public void addContent(CampaignLibraryNode node, int position) {
        CampaignLibraryNode campaignLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)campaignLibraryNode);
        this.folderSupport.addContent(node, position);
        this.content = new ArrayList<CampaignLibraryNode>(this.content);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.folderSupport.isContentNameAvailable(name);
    }

    @Override
    public CampaignFolder createCopy() {
        return this.folderSupport.createCopy(new CampaignFolder());
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        GenericProject former = this.getProject();
        super.notifyAssociatedWithProject(project);
        this.folderSupport.notifyAssociatedProjectWasSet((Project)former, project);
    }

    @Override
    public boolean hasContent() {
        return this.folderSupport.hasContent();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getContentNames() {
        return this.folderSupport.getContentNames();
    }

    @Override
    public Collection<CampaignLibraryNode> getOrderedContent() {
        return this.content;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.CAMPAIGN_FOLDER;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.CAMPAIGN_FOLDER, this.getId());
    }
}

