/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;

public class IssueOwnership<ISSUE> {
    private final ISSUE issue;
    private final IssueDetector owner;

    public IssueOwnership(ISSUE issue, IssueDetector owner) {
        this.issue = issue;
        this.owner = owner;
    }

    public IssueDetector getOwner() {
        return this.owner;
    }

    public ISSUE getIssue() {
        return this.issue;
    }

    public Execution getExecution() {
        Execution execution = null;
        if (ExecutionStep.class.isAssignableFrom(this.owner.getClass())) {
            ExecutionStep step = (ExecutionStep)this.owner;
            execution = step.getExecution();
        } else if (Execution.class.isAssignableFrom(this.owner.getClass())) {
            execution = (Execution)this.owner;
        }
        return execution;
    }

    public String toString() {
        return "IssueOwnership [issue=" + String.valueOf(this.issue) + ", owner=" + String.valueOf(this.owner) + "]";
    }
}

