/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.execution.Execution;

@Entity
@NamedQueries(value={@NamedQuery(name="Issue.findAllForIteration", query="select i from Issue i join fetch i.bugtracker join fetch i.issueList where i.id in\n(select ei.id from Iteration it\n    join it.testPlan.testPlanItems itp\n    join itp.executions e\n    join e.issueList eil\n    join eil.issues ei\n    where it.id = :id)\nor i.id in\n(select esi.id from Iteration it\n    join it.testPlan.testPlanItems itp\n    join itp.executions e\n    join e.steps es\n    join es.issueList esil\n    join esil.issues esi\n    where it.id = :id)\n"), @NamedQuery(name="Issue.findAllForTestSuite", query="select i from Issue i join fetch i.bugtracker join fetch i.issueList where i.id in\n(select ei.id from TestPlanItem itp\n    join itp.testSuites ts\n    join itp.executions e\n    join e.issueList eil\n    join eil.issues ei\n    where :id in (select suites.id from itp.testSuites suites))\nor i.id in\n(select esi.id from TestPlanItem itp\n    join itp.testSuites ts\n    join itp.executions e\n    join e.steps es\n    join es.issueList esil\n    join esil.issues esi\n    where :id in (select suites.id from itp.testSuites suites))\n"), @NamedQuery(name="Issue.findAllForSprint", query="select i from Issue i join fetch i.bugtracker join fetch i.issueList where i.id in\n(select ei.id from Sprint sprint\n    join sprint.sprintReqVersions srv\n    join srv.testPlan tp\n    join tp.testPlanItems item\n    join item.executions e\n    join e.issueList eil\n    join eil.issues ei\n    where sprint.id = :id)\nor i.id in\n(select esi.id from Sprint sprint\n    join sprint.sprintReqVersions srv\n    join srv.testPlan tp\n    join tp.testPlanItems item\n    join item.executions e\n    join e.steps es\n    join es.issueList esil\n    join esil.issues esi\n    where sprint.id = :id)\n"), @NamedQuery(name="Issue.findExecution", query="select exec from Execution exec\n    join exec.issueList eil\n    join eil.issues issue\n    where issue.id = :id\n"), @NamedQuery(name="Issue.findExecutionStep", query="select execStep from ExecutionStep execStep\n    join execStep.issueList esil\n    join esil.issues issue\n    where issue.id = :id\n"), @NamedQuery(name="Issue.findSessionNote", query="select sessionNote from SessionNote sessionNote\n    join sessionNote.issueList snil\n    join snil.issues issue\n    where issue.id = :id\n"), @NamedQuery(name="Issue.findFailureDetail", query="select failureDetail from FailureDetail failureDetail\n    join failureDetail.issueList fdil\n    join fdil.issues issue\n    where issue.id = :id\n")})
public class Issue
implements Identified {
    @Id
    @Column(name="ISSUE_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="issue_issue_id_seq")
    @SequenceGenerator(name="issue_issue_id_seq", sequenceName="issue_issue_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="ISSUE_LIST_ID")
    private IssueList issueList;
    @OneToOne(optional=false)
    @JoinColumn(name="BUGTRACKER_ID", foreignKey=@ForeignKey(name="FK_Issue_Bugtracker"))
    private BugTracker bugtracker;
    @Transient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="EXECUTION_ISSUES_CLOSURE", joinColumns={@JoinColumn(name="ISSUE_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="EXECUTION_ID")})
    private Execution execution;
    private String remoteIssueId;
    private String additionalData;

    @Override
    public Long getId() {
        return this.id;
    }

    public String getRemoteIssueId() {
        return this.remoteIssueId;
    }

    public void setRemoteIssueId(String btId) {
        this.remoteIssueId = btId;
    }

    public IssueList getIssueList() {
        return this.issueList;
    }

    void setIssueList(IssueList issueList) {
        this.issueList = issueList;
    }

    public BugTracker getBugtracker() {
        return this.bugtracker;
    }

    public void setBugtracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public Issue duplicateFailureDetailExecutionForExecution(Execution execution) {
        Issue newIssue = new Issue();
        newIssue.setRemoteIssueId(this.getRemoteIssueId());
        newIssue.setBugtracker(this.getBugtracker());
        newIssue.setAdditionalData(this.getAdditionalData());
        newIssue.setIssueList(execution.getIssueList());
        return newIssue;
    }
}

