/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bugtracker;

import jakarta.persistence.Entity;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.servers.ThirdPartyServer;

@Entity
@Table(name="BUGTRACKER")
@PrimaryKeyJoinColumn(name="BUGTRACKER_ID")
public class BugTracker
extends ThirdPartyServer {
    public static final BugTracker NOT_DEFINED = new BugTracker();
    @NotBlank
    @Size(max=50)
    private @NotBlank @Size(max=50) String kind;
    private boolean iframeFriendly;

    static {
        NOT_DEFINED.setName("");
        NOT_DEFINED.setUrl("");
        BugTracker.NOT_DEFINED.kind = "none";
        BugTracker.NOT_DEFINED.iframeFriendly = true;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean isIframeFriendly() {
        return this.iframeFriendly;
    }

    public void setIframeFriendly(boolean iframeFriendly) {
        this.iframeFriendly = iframeFriendly;
    }

    public BugTracker getDetachedBugTracker() {
        BugTracker detached = new BugTracker();
        detached.setName(this.getName());
        detached.setUrl(this.getUrl());
        detached.setAuthenticationPolicy(this.getAuthenticationPolicy());
        detached.setAuthenticationProtocol(this.getAuthenticationProtocol());
        detached.kind = this.kind;
        detached.iframeFriendly = this.iframeFriendly;
        return detached;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BugTracker{");
        sb.append("id=").append(this.getId());
        sb.append(", name='").append(this.getName()).append('\'');
        sb.append(", url='").append(this.getUrl()).append('\'');
        sb.append(", kind='").append(this.kind).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

