/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.bdd.AbstractActionWordParser;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordTokenizer;
import org.squashtest.tm.exception.actionword.InvalidTestCaseParameterNameInActionException;

public class KeywordTestStepActionWordParser
extends AbstractActionWordParser {
    public ActionWord createActionWordFromKeywordTestStep(String input) {
        List<ActionWordTokenizer.AWToken> tokens = this.checkInputAndParseTokens(input, true);
        for (ActionWordTokenizer.AWToken token : tokens) {
            switch (token.getType()) {
                case PLAIN_TEXT: {
                    this.addTextFragment(token);
                    break;
                }
                case ANGLED_VALUE: {
                    this.addNamedParameter(token);
                    break;
                }
                case QUOTED_VALUE: {
                    this.addFreeValue(token);
                    break;
                }
                case NUMBER: {
                    this.addNumberFragment(token);
                }
            }
        }
        return new ActionWord(this.fragments);
    }

    private void addNamedParameter(ActionWordTokenizer.AWToken token) {
        String testCaseParameterName = this.canonicalizeTestCaseParameterName(token.getLexeme());
        this.addParameter(this.getNextParamName(), "", testCaseParameterName);
    }

    private String canonicalizeTestCaseParameterName(String candidateName) {
        if (candidateName.startsWith("<") && candidateName.endsWith(">")) {
            if (candidateName.length() < 3) {
                throw new InvalidTestCaseParameterNameInActionException("Test case parameter name cannot be blank.");
            }
            candidateName = candidateName.substring(1, candidateName.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)candidateName)) {
            throw new InvalidTestCaseParameterNameInActionException("Test case parameter name cannot be blank.");
        }
        if (!this.isLegalTestCaseParameterName(candidateName = candidateName.trim().replaceAll("(\\s)+", "_"))) {
            throw new InvalidTestCaseParameterNameInActionException("Test case parameter name can contain only alphanumeric, - and _ characters.");
        }
        candidateName = candidateName.replaceAll("[^\\w-]", "_");
        return "<" + candidateName + ">";
    }

    private boolean isLegalTestCaseParameterName(String candidate) {
        return candidate.matches("[a-zA-Z0-9\\-_\\s]*");
    }

    private void addFreeValue(ActionWordTokenizer.AWToken token) {
        String value = token.getLexeme().substring(1, token.getLexeme().length() - 1);
        this.addParameter(this.getNextParamName(), value, value);
    }
}

