/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.bdd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.bdd.ContextualizedActionWordException;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.exception.actionword.InvalidActionWordInputNameException;
import org.squashtest.tm.exception.actionword.InvalidActionWordTextException;

public class ActionWordTokenizer {
    private static final List<Character> DELIMITERS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'));
    private final String source;
    private final boolean allowsNamedParameters;
    private int start = 0;
    private int current = 0;
    private final List<AWToken> tokens = new ArrayList<AWToken>();

    ActionWordTokenizer(String source, boolean allowsAngledValues) {
        this.source = source;
        this.allowsNamedParameters = allowsAngledValues;
    }

    public List<AWToken> tokenize() {
        while (!this.isAtEnd()) {
            this.start = this.current;
            this.scanToken();
        }
        return this.tokens;
    }

    private boolean isAtEnd() {
        return this.current >= this.source.length();
    }

    private void scanToken() {
        char c = this.peek();
        switch (c) {
            case '\"': {
                this.parseQuotedValue();
                break;
            }
            case '<': {
                this.parseAngledValue();
                break;
            }
            case '>': {
                this.handleHangingCloseAngle();
                break;
            }
            default: {
                this.parsePlainTextAndNumbers();
            }
        }
    }

    private void handleHangingCloseAngle() {
        if (this.allowsNamedParameters) {
            throw new InvalidActionWordTextException("Expected opening delimiter '<' before closing '>' delimiter.");
        }
        throw new InvalidActionWordInputNameException();
    }

    private char peek() {
        if (this.isAtEnd()) {
            return '\u0000';
        }
        return this.source.charAt(this.current);
    }

    private char peekNext() {
        if (this.current + 1 >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.current + 1);
    }

    private void advance() {
        ++this.current;
    }

    private void parseQuotedValue() {
        this.advance();
        int openPosition = this.current;
        this.consumeQuotedText();
        if (this.peek() != '\"' || this.isAtEnd()) {
            throw new UnclosedQuotedValue(openPosition, this.source);
        }
        this.advance();
        String text = this.source.substring(this.start, this.current);
        this.tokens.add(new AWToken(AWTokenType.QUOTED_VALUE, text));
    }

    private void parseAngledValue() {
        if (!this.allowsNamedParameters) {
            throw new ForbiddenAngleException(this.current + 1, this.source);
        }
        this.advance();
        int openPosition = this.current;
        while (this.peek() != '>' && !this.isAtEnd()) {
            this.advance();
        }
        if (this.isAtEnd()) {
            throw new UnclosedAngledValue(openPosition, this.source);
        }
        this.advance();
        String parameterName = this.source.substring(this.start, this.current);
        this.tokens.add(new AWToken(AWTokenType.ANGLED_VALUE, parameterName));
    }

    private void parsePlainTextAndNumbers() {
        String valueSoFar = this.consumeText();
        this.addTextAndNumbers(valueSoFar);
    }

    private void addTextAndNumbers(String valueSoFar) {
        if (StringUtils.isBlank((CharSequence)valueSoFar)) {
            this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, valueSoFar));
            return;
        }
        String[] split = valueSoFar.split("((?<=\\s)|(?=\\s+))");
        StringBuilder textBuilder = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (ActionWordUtil.isNumber(part)) {
                if (textBuilder.length() > 0) {
                    this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, textBuilder.toString()));
                    textBuilder.setLength(0);
                }
                this.tokens.add(new AWToken(AWTokenType.NUMBER, part));
            } else {
                textBuilder.append(part);
            }
            ++n2;
        }
        if (textBuilder.length() > 0) {
            this.tokens.add(new AWToken(AWTokenType.PLAIN_TEXT, textBuilder.toString()));
        }
    }

    private String consumeText() {
        while (!ActionWordTokenizer.isDelimiter(this.peek()) && !this.isAtEnd()) {
            if (this.peek() == '\\' && ActionWordUtil.isEscapableCharacter(this.peekNext())) {
                this.advance();
            }
            this.advance();
        }
        return this.source.substring(this.start, this.current);
    }

    private String consumeQuotedText() {
        while (this.peek() != '\"' && !this.isAtEnd()) {
            if (this.peek() == '\\' && ActionWordUtil.isEscapableCharacter(this.peekNext())) {
                this.advance();
            }
            this.advance();
        }
        return this.source.substring(this.start, this.current);
    }

    private static boolean isDelimiter(char c) {
        return DELIMITERS.contains(Character.valueOf(c));
    }

    public static class AWToken {
        private final AWTokenType type;
        private final String lexeme;

        public AWToken(AWTokenType type, String lexeme) {
            this.type = type;
            this.lexeme = lexeme;
        }

        public AWTokenType getType() {
            return this.type;
        }

        public String getLexeme() {
            return this.lexeme;
        }
    }

    public static enum AWTokenType {
        PLAIN_TEXT,
        NUMBER,
        QUOTED_VALUE,
        ANGLED_VALUE;

    }

    static class ForbiddenAngleException
    extends ContextualizedActionWordException {
        private static final long serialVersionUID = 3100361789902011837L;

        ForbiddenAngleException(int delimiterPosition, String textInput) {
            super("The action word name cannot contain the < and > symbols.", textInput, delimiterPosition);
        }

        public String getI18nKey() {
            return "sqtm-core.error.action-word.input.name";
        }
    }

    static class UnclosedAngledValue
    extends ContextualizedActionWordException {
        private static final long serialVersionUID = 5477067690601248023L;

        UnclosedAngledValue(int delimiterPosition, String textInput) {
            super("Found unclosed angle bracket (<) delimiter.", textInput, delimiterPosition);
        }

        public String getI18nKey() {
            return "sqtm-core.error.action-word.unclosed-angled-value";
        }
    }

    static class UnclosedQuotedValue
    extends ContextualizedActionWordException {
        private static final long serialVersionUID = -6590561736625746937L;

        UnclosedQuotedValue(int delimiterPosition, String textInput) {
            super("Found unclosed quote (\") delimiter.", textInput, delimiterPosition);
        }

        public String getI18nKey() {
            return "sqtm-core.error.action-word.unclosed-quoted-value";
        }
    }
}

