/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.audit;

import jakarta.persistence.Embedded;
import jakarta.persistence.MappedSuperclass;
import java.util.Date;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.security.UserContextHolder;

@MappedSuperclass
public class BaseAuditableEntity
implements AuditableMixin {
    @Embedded
    private AuditableSupport audit = new AuditableSupport();

    public void updateLastModificationWithCurrentUser() {
        this.setLastModifiedOn(new Date());
        this.setLastModifiedBy(UserContextHolder.getUsername());
    }

    @Override
    public Date getCreatedOn() {
        return this.audit.getCreatedOn();
    }

    @Override
    public String getCreatedBy() {
        return this.audit.getCreatedBy();
    }

    @Override
    public Date getLastModifiedOn() {
        return this.audit.getLastModifiedOn();
    }

    @Override
    public String getLastModifiedBy() {
        return this.audit.getLastModifiedBy();
    }

    @Override
    public boolean isSkipModifyAudit() {
        return this.audit.isSkipModifyAudit();
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.audit.setCreatedBy(createdBy);
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.audit.setCreatedOn(createdOn);
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.audit.setLastModifiedBy(lastModifiedBy);
    }

    @Override
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.audit.setLastModifiedOn(lastModifiedOn);
    }

    @Override
    public void setSkipModifyAudit(boolean skipModifyAudit) {
        this.audit.setSkipModifyAudit(skipModifyAudit);
    }

    @Override
    public void setReadOnlyModifyAudit(String readOnlyLastModifiedBy, Date readOnlyLastModifiedOn) {
        this.audit.setReadOnlyModifyAudit(readOnlyLastModifiedBy, readOnlyLastModifiedOn);
    }
}

