/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.attachment;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.SequenceGenerator;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.JDBCException;

@Entity
public class AttachmentContent {
    @Id
    @Column(name="ATTACHMENT_CONTENT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="attachment_content_attachment_content_id_seq")
    @SequenceGenerator(name="attachment_content_attachment_content_id_seq", sequenceName="attachment_content_attachment_content_id_seq", allocationSize=1)
    private Long id;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private Blob streamContent;

    public InputStream getStream() {
        try {
            return this.streamContent.getBinaryStream();
        }
        catch (SQLException e) {
            throw new JDBCException("Cannot read blob property as a stream", e);
        }
    }

    public byte[] getBytes() {
        try {
            return this.streamContent.getBytes(1L, (int)this.streamContent.length());
        }
        catch (SQLException e) {
            throw new JDBCException("Cannot read blob property as a stream", e);
        }
    }

    public void setContent(Blob content) {
        this.streamContent = content;
    }

    public AttachmentContent hardCopy() {
        AttachmentContent clone = new AttachmentContent();
        clone.streamContent = this.streamContent;
        return clone;
    }

    public Long getId() {
        return this.id;
    }
}

