/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.attachment;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.Locale;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.attachment.AttachmentContent;
import org.squashtest.tm.domain.attachment.AttachmentList;

@Entity
public class Attachment
implements Identified {
    private static final float MEGA_BYTE = 1048576.0f;
    @Id
    @Column(name="ATTACHMENT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="attachment_attachment_id_seq")
    @SequenceGenerator(name="attachment_attachment_id_seq", sequenceName="attachment_attachment_id_seq", allocationSize=1)
    private Long id;
    @NotEmpty
    private String name;
    private String type;
    @Column(name="SIZE")
    private Long contentSize = 0L;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="CONTENT_ID")
    private AttachmentContent content;
    @ManyToOne
    @JoinColumn(name="ATTACHMENT_LIST_ID", nullable=false, updatable=false)
    private AttachmentList attachmentList;
    @Transient
    private Long attachmentToCopyId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date addedOn;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedOn;

    public Attachment() {
    }

    public Attachment(String name) {
        this.doSetName(name);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public AttachmentContent getContent() {
        return this.content;
    }

    public void setContent(AttachmentContent content) {
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.doSetName(name);
    }

    private void doSetName(String name) {
        this.name = name;
        this.setType();
    }

    @NotBlank
    public String getShortName() {
        int position = this.name.lastIndexOf(46);
        return this.name.substring(0, position);
    }

    public void setShortName(String shortName) {
        this.name = shortName + "." + this.type;
    }

    public void setType(String strType) {
        this.type = strType.trim();
    }

    private void setType() {
        if (this.name != null) {
            int position = this.name.lastIndexOf(46);
            this.setType(this.name.substring(position + 1));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setAddedOn(Date addedOn) {
        this.addedOn = addedOn;
    }

    public Date getAddedOn() {
        return this.addedOn;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public Long getSize() {
        return this.contentSize;
    }

    public void setSize(Long size) {
        this.contentSize = size;
    }

    public String getFormattedSize() {
        return this.getFormattedSize(Locale.getDefault());
    }

    public String getFormattedSize(Locale locale) {
        Float megaSize = Float.valueOf((float)this.contentSize.longValue() / 1048576.0f);
        return String.format(locale, "%.2f", megaSize);
    }

    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(AttachmentList attachmentList) {
        this.attachmentList = attachmentList;
    }

    public Long getAttachmentToCopyId() {
        return this.attachmentToCopyId;
    }

    public void setAttachmentToCopyId(Long attachmentToCopyId) {
        this.attachmentToCopyId = attachmentToCopyId;
    }

    public Attachment shallowCopy() {
        Attachment clone = new Attachment();
        clone.setName(this.getName());
        clone.setSize(this.getSize());
        clone.setType(this.getType());
        clone.setAddedOn(new Date());
        clone.setLastModifiedOn(new Date());
        clone.setAttachmentToCopyId(this.getId());
        if (this.getContent() != null) {
            clone.setContent(this.getContent());
        }
        return clone;
    }

    public Attachment hardCopy() {
        Attachment clone = new Attachment();
        clone.setName(this.getName());
        clone.setSize(this.getSize());
        clone.setType(this.getType());
        clone.setAddedOn(new Date());
        clone.setLastModifiedOn(new Date());
        clone.setAttachmentToCopyId(this.getId());
        if (this.getContent() != null) {
            clone.setContent(this.getContent().hardCopy());
        }
        return clone;
    }
}

