/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.actionword;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.Cascade;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.actionword.ActionWordTreeLibraryNode;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.util.ActionWordUtil;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Table(name="ACTION_WORD_LIBRARY_NODE")
public class ActionWordLibraryNode
implements ActionWordTreeLibraryNode {
    private static final String AWLN_ID = "AWLN_ID";
    @Id
    @Column(name="AWLN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="action_word_library_node_awln_id_seq")
    @SequenceGenerator(name="action_word_library_node_awln_id_seq", sequenceName="action_word_library_node_awln_id_seq", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ENTITY_TYPE", insertable=false, updatable=false)
    private ActionWordTreeDefinition entityType;
    @Column(name="ENTITY_ID", insertable=false, updatable=false)
    private Long entityId;
    @Size(max=255)
    private @Size(max=255) String name;
    @JoinTable(name="AWLN_RELATIONSHIP", joinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="AWLN_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="AWLN_ID", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=ActionWordLibraryNode.class)
    private ActionWordTreeLibraryNode parent;
    @JoinTable(name="AWLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID", referencedColumnName="AWLN_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID", referencedColumnName="AWLN_ID")})
    @OneToMany(fetch=FetchType.LAZY, targetEntity=ActionWordLibraryNode.class, cascade={CascadeType.ALL})
    @OrderColumn(name="CONTENT_ORDER")
    private List<ActionWordTreeLibraryNode> children = new ArrayList<ActionWordTreeLibraryNode>();
    @Any(fetch=FetchType.LAZY)
    @AnyDiscriminator(value=DiscriminatorType.STRING)
    @AnyDiscriminatorValues(value={@AnyDiscriminatorValue(discriminator="LIBRARY", entity=ActionWordLibrary.class), @AnyDiscriminatorValue(discriminator="ACTION_WORD", entity=ActionWord.class)})
    @AnyKeyJavaClass(value=Long.class)
    @Column(name="ENTITY_TYPE")
    @JoinColumn(name="ENTITY_ID")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private ActionWordTreeEntity entity;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="AWL_ID")
    private ActionWordLibrary library;

    public ActionWordLibraryNode() {
    }

    public ActionWordLibraryNode(ActionWordTreeDefinition entityType, Long entityId, @Size(max=255) @Size(max=255) String name, ActionWordLibrary library) {
        this.entityType = entityType;
        this.entityId = entityId;
        this.name = name;
        this.library = library;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public void isCoherentWithEntity() {
        String entityName;
        String nodeName = this.getName();
        if (!nodeName.equals(entityName = this.getEntity().getName())) {
            String message = "Cannot add a library node with name %s to represent an entity with different name %s.";
            throw new IllegalArgumentException(String.format(message, nodeName, entityName));
        }
    }

    @Override
    public boolean childNameAlreadyUsed(String newChildName) {
        for (TreeLibraryNode treeLibraryNode : this.children) {
            if (!treeLibraryNode.getName().equals(newChildName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasContent() {
        if (!this.getEntityType().isContainer()) {
            return false;
        }
        return !this.children.isEmpty();
    }

    @Override
    public void renameNode(String newName) {
        if (this.getEntityType().equals(ActionWordTreeDefinition.LIBRARY)) {
            throw new IllegalArgumentException("A library cannot be renamed. Please rename the project instead.");
        }
        if (this.nameAlreadyUsedBySibling(newName)) {
            throw new DuplicateNameException(newName, this.getEntityType().getTypeName());
        }
        this.setName(newName);
    }

    private boolean nameAlreadyUsedBySibling(String newName) {
        List<String> siblingsNames = this.getSiblingsNames();
        return siblingsNames.contains(newName);
    }

    private List<String> getSiblingsNames() {
        List<ActionWordTreeLibraryNode> siblings = this.getSiblings();
        ArrayList<String> siblingNames = new ArrayList<String>();
        for (TreeLibraryNode treeLibraryNode : siblings) {
            siblingNames.add(treeLibraryNode.getName());
        }
        return siblingNames;
    }

    private List<ActionWordTreeLibraryNode> getSiblings() {
        ActionWordTreeLibraryNode parentNode = this.getParent();
        return parentNode.getChildren();
    }

    @Override
    public ActionWordTreeDefinition getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntityType(ActionWordTreeDefinition entityType) {
        this.entityType = entityType;
    }

    @Override
    public ActionWordTreeEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(ActionWordTreeEntity treeEntity) {
        this.entity = treeEntity;
    }

    @Override
    @AclConstrainedObject
    public ActionWordLibrary getLibrary() {
        return this.library;
    }

    @Override
    public void setLibrary(ActionWordLibrary library) {
        this.library = library;
    }

    @Override
    public ActionWordTreeLibraryNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ActionWordTreeLibraryNode parent) {
        this.parent = parent;
    }

    @Override
    public List<ActionWordTreeLibraryNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(ActionWordTreeLibraryNode treeLibraryNode, boolean tokenCaseInsensitivity) throws UnsupportedOperationException, IllegalArgumentException, NameAlreadyInUseException {
        if (treeLibraryNode == null) {
            throw new IllegalArgumentException("Cannot add a null child to a library node.");
        }
        if (treeLibraryNode.getEntity() == null) {
            throw new IllegalArgumentException("Cannot add a library node representing a null entity.");
        }
        if (!this.getEntityType().isContainer()) {
            throw new UnsupportedOperationException("This type of library node doesn't accept children.");
        }
        treeLibraryNode.isCoherentWithEntity();
        String newChildName = treeLibraryNode.getName();
        ActionWordTreeLibraryNode sameTokenNode = this.getContentNodeByToken(newChildName, tokenCaseInsensitivity);
        if (sameTokenNode != null) {
            throw new DuplicateNameException(sameTokenNode.getEntityType().getTypeName(), newChildName);
        }
        this.getChildren().add(treeLibraryNode);
    }

    private ActionWordTreeLibraryNode getContentNodeByToken(String newChildName, boolean tokenCaseInsensitivity) {
        for (ActionWordTreeLibraryNode child : this.children) {
            if (!ActionWordUtil.hasSameToken(child.getName(), newChildName, tokenCaseInsensitivity)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void removeChild(ActionWordTreeLibraryNode treeLibraryNode) {
        this.children.remove(treeLibraryNode);
        this.children = new ArrayList<ActionWordTreeLibraryNode>(this.children);
    }
}

