/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.acl;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Field;
import org.squashtest.tm.domain.acl.UnknownAclClassException;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;

public enum AclClass {
    PROJECT(Project.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.PROJECT_ID),
    PROJECT_TEMPLATE(ProjectTemplate.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.PROJECT_ID),
    REQUIREMENT_LIBRARY(RequirementLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.RL_ID),
    TEST_CASE_LIBRARY(TestCaseLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.TCL_ID),
    CAMPAIGN_LIBRARY(CampaignLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.CL_ID),
    CUSTOM_REPORT_LIBRARY(CustomReportLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.CRL_ID),
    AUTOMATION_REQUEST_LIBRARY(AutomationRequestLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.ARL_ID),
    ACTION_WORD_LIBRARY(ActionWordLibrary.class, (Field<Long>)org.squashtest.tm.jooq.domain.tables.Project.PROJECT.AWL_ID);

    private final String className;
    private final String simpleClassName;
    private final Field<Long> identityColumn;

    private AclClass(Class<?> entityClass, Field<Long> identityColumn) {
        this.className = entityClass.getName();
        this.simpleClassName = entityClass.getSimpleName();
        this.identityColumn = identityColumn;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSimpleClassName() {
        return this.simpleClassName;
    }

    public Field<Long> getIdentityColumn() {
        return this.identityColumn;
    }

    public static AclClass findByClassName(String className) {
        Map aclClassByName = EnumSet.allOf(AclClass.class).stream().collect(Collectors.toMap(AclClass::getClassName, Function.identity()));
        if (aclClassByName.containsKey(className)) {
            return (AclClass)((Object)aclClassByName.get(className));
        }
        throw new UnknownAclClassException(className);
    }
}

