/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;

public class NodeReferences {
    private Set<NodeReference> nodeReferences;

    public NodeReferences(Set<NodeReference> nodeReferences) {
        this.nodeReferences = nodeReferences;
    }

    public NodeReferences(List<NodeReference> nodeReferences) {
        this(new HashSet<NodeReference>(nodeReferences));
    }

    public static NodeReferences fromStrings(List<String> nodeReferences) {
        Set<NodeReference> references = NodeReference.fromNodeIds(nodeReferences);
        return new NodeReferences(references);
    }

    public void removeLibraries() {
        this.nodeReferences = this.getNonLibraryStream().collect(Collectors.toSet());
    }

    public Set<NodeReference> extractLibraries() {
        return this.getLibraryStream().collect(Collectors.toSet());
    }

    public Set<NodeReference> extractNonLibraries() {
        return this.getNonLibraryStream().collect(Collectors.toSet());
    }

    public Set<NodeReference> extractNonLibrariesByType(NodeType nodeType) {
        return this.getNonLibraryStream().filter(nodeReference -> nodeType == nodeReference.getNodeType()).collect(Collectors.toSet());
    }

    public Set<Long> extractLibraryIds() {
        return this.getLibraryStream().collect(NodeReferences.toIdSet());
    }

    public Set<Long> extractNonLibraryIds() {
        return this.getNonLibraryStream().collect(NodeReferences.toIdSet());
    }

    public Set<NodeReference> asSet() {
        return this.nodeReferences;
    }

    private Stream<NodeReference> asStream() {
        return this.nodeReferences.stream();
    }

    private Stream<NodeReference> getLibraryStream() {
        return this.asStream().filter(nodeReference -> nodeReference.getNodeType().isLibrary());
    }

    private Stream<NodeReference> getNonLibraryStream() {
        return this.asStream().filter(nodeReference -> !nodeReference.getNodeType().isLibrary());
    }

    private static Collector<NodeReference, Set<Long>, Set<Long>> toIdSet() {
        return Collector.of(HashSet::new, (ids, nodeReference) -> {
            boolean bl = ids.add(nodeReference.getId());
        }, (a, b) -> {
            throw new RuntimeException("Not concurrent collector");
        }, new Collector.Characteristics[0]);
    }

    public boolean isEmpty() {
        return this.nodeReferences.isEmpty();
    }

    public Set<EntityReference> toEntityReferences() {
        return this.asStream().map(NodeReference::toEntityReference).collect(Collectors.toSet());
    }
}

