/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain;

import java.util.Collections;
import java.util.EnumSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.LevelComparator;

public final class LevelUtils {
    private LevelUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static <L extends Enum<L>> SortedSet<L> filterLevelEnum(Class<L> enumClass, Predicate<L> filterFunction) {
        return Collections.unmodifiableSortedSet(EnumSet.allOf(enumClass).stream().filter(filterFunction).sorted(LevelComparator.getInstance()).collect(Collectors.toCollection(TreeSet::new)));
    }

    public static <L extends Enum<L>> SortedSet<L> excludeFromLevelEnum(Class<L> enumClass, Predicate<L> filterFunction) {
        return LevelUtils.filterLevelEnum(enumClass, filterFunction.negate());
    }
}

