/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.ThirdPartyServer;
import org.squashtest.tm.jooq.domain.tables.records.StoredCredentialsRecord;

public class StoredCredentials
extends TableImpl<StoredCredentialsRecord> {
    private static final long serialVersionUID = 1L;
    public static final StoredCredentials STORED_CREDENTIALS = new StoredCredentials();
    public final TableField<StoredCredentialsRecord, Long> CREDENTIAL_ID = StoredCredentials.createField((Name)DSL.name((String)"CREDENTIAL_ID"), (DataType)SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field((SQL)DSL.raw((String)"NEXT VALUE FOR \"PUBLIC\".\"STORED_CREDENTIALS_CREDENTIAL_ID_SEQ\""), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"");
    public final TableField<StoredCredentialsRecord, Short> ENC_VERSION = StoredCredentials.createField((Name)DSL.name((String)"ENC_VERSION"), (DataType)SQLDataType.SMALLINT, (Table)this, (String)"the version of encryption service used. Possibly the value will remain to 1 forever.");
    public final TableField<StoredCredentialsRecord, String> ENC_CREDENTIALS = StoredCredentials.createField((Name)DSL.name((String)"ENC_CREDENTIALS"), (DataType)SQLDataType.CLOB, (Table)this, (String)"the credentials as an encrypted string");
    public final TableField<StoredCredentialsRecord, Long> AUTHENTICATED_SERVER = StoredCredentials.createField((Name)DSL.name((String)"AUTHENTICATED_SERVER"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"foreign key to the server to authenticate");
    public final TableField<StoredCredentialsRecord, String> CONTENT_TYPE = StoredCredentials.createField((Name)DSL.name((String)"CONTENT_TYPE"), (DataType)SQLDataType.VARCHAR((int)4).defaultValue(DSL.field((SQL)DSL.raw((String)"'CRED'"), (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"the role of the content, either CRED or CONF");
    public final TableField<StoredCredentialsRecord, Long> AUTHENTICATED_USER = StoredCredentials.createField((Name)DSL.name((String)"AUTHENTICATED_USER"), (DataType)SQLDataType.BIGINT.defaultValue(DSL.field((SQL)DSL.raw((String)"NULL"), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"Foreign key to the user account that owns the credentials. A NULL value means that Squash-TM               owns the credentials (app-level credentials).");
    public final TableField<StoredCredentialsRecord, Long> PROJECT_ID = StoredCredentials.createField((Name)DSL.name((String)"PROJECT_ID"), (DataType)SQLDataType.BIGINT.defaultValue(DSL.field((SQL)DSL.raw((String)"NULL"), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.");
    public final TableField<StoredCredentialsRecord, Boolean> REPORTING_CACHE_CREDENTIALS = StoredCredentials.createField((Name)DSL.name((String)"REPORTING_CACHE_CREDENTIALS"), (DataType)SQLDataType.BOOLEAN.defaultValue(DSL.field((SQL)DSL.raw((String)"FALSE"), (DataType)SQLDataType.BOOLEAN)), (Table)this, (String)"");
    private transient ThirdPartyServer.ThirdPartyServerPath _thirdPartyServer;
    private transient Project.ProjectPath _project;
    private transient CoreUser.CoreUserPath _coreUser;

    public Class<StoredCredentialsRecord> getRecordType() {
        return StoredCredentialsRecord.class;
    }

    private StoredCredentials(Name alias, Table<StoredCredentialsRecord> aliased) {
        this(alias, aliased, null, null);
    }

    private StoredCredentials(Name alias, Table<StoredCredentialsRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table(), where);
    }

    public StoredCredentials(String alias) {
        this(DSL.name((String)alias), (Table<StoredCredentialsRecord>)STORED_CREDENTIALS);
    }

    public StoredCredentials(Name alias) {
        this(alias, (Table<StoredCredentialsRecord>)STORED_CREDENTIALS);
    }

    public StoredCredentials() {
        this(DSL.name((String)"STORED_CREDENTIALS"), null);
    }

    public <O extends Record> StoredCredentials(Table<O> path, ForeignKey<O, StoredCredentialsRecord> childPath, InverseForeignKey<O, StoredCredentialsRecord> parentPath) {
        super(path, childPath, parentPath, (Table)STORED_CREDENTIALS);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER);
    }

    public UniqueKey<StoredCredentialsRecord> getPrimaryKey() {
        return Keys.PK_STORED_CREDENTIALS;
    }

    public List<UniqueKey<StoredCredentialsRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.UNIQ_STORED_CREDENTIALS_SERVER_USER);
    }

    public List<ForeignKey<StoredCredentialsRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER, Keys.FK_STORED_CREDENTIALS_PROJECT, Keys.FK_STORED_CREDENTIALS_USER);
    }

    public ThirdPartyServer.ThirdPartyServerPath thirdPartyServer() {
        if (this._thirdPartyServer == null) {
            this._thirdPartyServer = new ThirdPartyServer.ThirdPartyServerPath(this, Keys.FK_STORED_CREDENTIALS_AUTHENTICATED_SERVER, null);
        }
        return this._thirdPartyServer;
    }

    public Project.ProjectPath project() {
        if (this._project == null) {
            this._project = new Project.ProjectPath(this, Keys.FK_STORED_CREDENTIALS_PROJECT, null);
        }
        return this._project;
    }

    public CoreUser.CoreUserPath coreUser() {
        if (this._coreUser == null) {
            this._coreUser = new CoreUser.CoreUserPath(this, Keys.FK_STORED_CREDENTIALS_USER, null);
        }
        return this._coreUser;
    }

    public StoredCredentials as(String alias) {
        return new StoredCredentials(DSL.name((String)alias), (Table<StoredCredentialsRecord>)this);
    }

    public StoredCredentials as(Name alias) {
        return new StoredCredentials(alias, (Table<StoredCredentialsRecord>)this);
    }

    public StoredCredentials as(Table<?> alias) {
        return new StoredCredentials(alias.getQualifiedName(), (Table<StoredCredentialsRecord>)this);
    }

    public StoredCredentials rename(String name) {
        return new StoredCredentials(DSL.name((String)name), null);
    }

    public StoredCredentials rename(Name name) {
        return new StoredCredentials(name, null);
    }

    public StoredCredentials rename(Table<?> name) {
        return new StoredCredentials(name.getQualifiedName(), null);
    }

    public StoredCredentials where(Condition condition) {
        return new StoredCredentials(this.getQualifiedName(), (Table<StoredCredentialsRecord>)(this.aliased() ? this : null), null, condition);
    }

    public StoredCredentials where(Collection<? extends Condition> conditions) {
        return this.where(DSL.and(conditions));
    }

    public StoredCredentials where(Condition ... conditions) {
        return this.where(DSL.and((Condition[])conditions));
    }

    public StoredCredentials where(Field<Boolean> condition) {
        return this.where(DSL.condition(condition));
    }

    @PlainSQL
    public StoredCredentials where(SQL condition) {
        return this.where(DSL.condition((SQL)condition));
    }

    @PlainSQL
    public StoredCredentials where(String condition) {
        return this.where(DSL.condition((String)condition));
    }

    @PlainSQL
    public StoredCredentials where(String condition, Object ... binds) {
        return this.where(DSL.condition((String)condition, (Object[])binds));
    }

    @PlainSQL
    public StoredCredentials where(String condition, QueryPart ... parts) {
        return this.where(DSL.condition((String)condition, (QueryPart[])parts));
    }

    public StoredCredentials whereExists(Select<?> select) {
        return this.where(DSL.exists(select));
    }

    public StoredCredentials whereNotExists(Select<?> select) {
        return this.where(DSL.notExists(select));
    }

    public static class StoredCredentialsPath
    extends StoredCredentials
    implements Path<StoredCredentialsRecord> {
        private static final long serialVersionUID = 1L;

        public <O extends Record> StoredCredentialsPath(Table<O> path, ForeignKey<O, StoredCredentialsRecord> childPath, InverseForeignKey<O, StoredCredentialsRecord> parentPath) {
            super(path, childPath, parentPath);
        }

        private StoredCredentialsPath(Name alias, Table<StoredCredentialsRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public StoredCredentialsPath as(String alias) {
            return new StoredCredentialsPath(DSL.name((String)alias), (Table<StoredCredentialsRecord>)this);
        }

        @Override
        public StoredCredentialsPath as(Name alias) {
            return new StoredCredentialsPath(alias, (Table<StoredCredentialsRecord>)this);
        }

        @Override
        public StoredCredentialsPath as(Table<?> alias) {
            return new StoredCredentialsPath(alias.getQualifiedName(), (Table<StoredCredentialsRecord>)this);
        }
    }
}

