/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.ScmServer;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.records.ScmRepositoryRecord;

public class ScmRepository
extends TableImpl<ScmRepositoryRecord> {
    private static final long serialVersionUID = 1L;
    public static final ScmRepository SCM_REPOSITORY = new ScmRepository();
    public final TableField<ScmRepositoryRecord, Long> SCM_REPOSITORY_ID = ScmRepository.createField((Name)DSL.name((String)"SCM_REPOSITORY_ID"), (DataType)SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field((SQL)DSL.raw((String)"NEXT VALUE FOR \"PUBLIC\".\"SCM_REPOSITORY_SCM_REPOSITORY_ID_SEQ\""), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"");
    public final TableField<ScmRepositoryRecord, Long> SERVER_ID = ScmRepository.createField((Name)DSL.name((String)"SERVER_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"The foreign key to the related SCM_SEVER");
    public final TableField<ScmRepositoryRecord, String> NAME = ScmRepository.createField((Name)DSL.name((String)"NAME"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The name of the repository.");
    public final TableField<ScmRepositoryRecord, String> WORKING_BRANCH = ScmRepository.createField((Name)DSL.name((String)"WORKING_BRANCH"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The name of the working branch on which SquashTM will push.");
    public final TableField<ScmRepositoryRecord, String> REPOSITORY_PATH = ScmRepository.createField((Name)DSL.name((String)"REPOSITORY_PATH"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"The absolute path to the local repository on the local server.");
    public final TableField<ScmRepositoryRecord, String> WORKING_FOLDER_PATH = ScmRepository.createField((Name)DSL.name((String)"WORKING_FOLDER_PATH"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"The relative path of the working folder in which SquashTM will push.");
    private transient ScmServer.ScmServerPath _scmServer;
    private transient Project.ProjectPath _project;
    private transient TestCase.TestCasePath _testCase;

    public Class<ScmRepositoryRecord> getRecordType() {
        return ScmRepositoryRecord.class;
    }

    private ScmRepository(Name alias, Table<ScmRepositoryRecord> aliased) {
        this(alias, aliased, null, null);
    }

    private ScmRepository(Name alias, Table<ScmRepositoryRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table(), where);
    }

    public ScmRepository(String alias) {
        this(DSL.name((String)alias), (Table<ScmRepositoryRecord>)SCM_REPOSITORY);
    }

    public ScmRepository(Name alias) {
        this(alias, (Table<ScmRepositoryRecord>)SCM_REPOSITORY);
    }

    public ScmRepository() {
        this(DSL.name((String)"SCM_REPOSITORY"), null);
    }

    public <O extends Record> ScmRepository(Table<O> path, ForeignKey<O, ScmRepositoryRecord> childPath, InverseForeignKey<O, ScmRepositoryRecord> parentPath) {
        super(path, childPath, parentPath, (Table)SCM_REPOSITORY);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_FK_SCM_REPOSITORY_SCM_SERVER);
    }

    public UniqueKey<ScmRepositoryRecord> getPrimaryKey() {
        return Keys.PK_SCM_REPOSITORY;
    }

    public List<UniqueKey<ScmRepositoryRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.UNIQ_SCM_REPO_NAME_BRANCH_SERVER_ID);
    }

    public List<ForeignKey<ScmRepositoryRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_SCM_REPOSITORY_SCM_SERVER);
    }

    public ScmServer.ScmServerPath scmServer() {
        if (this._scmServer == null) {
            this._scmServer = new ScmServer.ScmServerPath(this, Keys.FK_SCM_REPOSITORY_SCM_SERVER, null);
        }
        return this._scmServer;
    }

    public Project.ProjectPath project() {
        if (this._project == null) {
            this._project = new Project.ProjectPath(this, null, Keys.FK_PROJECT_SCM_REPOSITORY.getInverseKey());
        }
        return this._project;
    }

    public TestCase.TestCasePath testCase() {
        if (this._testCase == null) {
            this._testCase = new TestCase.TestCasePath(this, null, Keys.FK_TC_SCM_REPOSITORY.getInverseKey());
        }
        return this._testCase;
    }

    public ScmRepository as(String alias) {
        return new ScmRepository(DSL.name((String)alias), (Table<ScmRepositoryRecord>)this);
    }

    public ScmRepository as(Name alias) {
        return new ScmRepository(alias, (Table<ScmRepositoryRecord>)this);
    }

    public ScmRepository as(Table<?> alias) {
        return new ScmRepository(alias.getQualifiedName(), (Table<ScmRepositoryRecord>)this);
    }

    public ScmRepository rename(String name) {
        return new ScmRepository(DSL.name((String)name), null);
    }

    public ScmRepository rename(Name name) {
        return new ScmRepository(name, null);
    }

    public ScmRepository rename(Table<?> name) {
        return new ScmRepository(name.getQualifiedName(), null);
    }

    public ScmRepository where(Condition condition) {
        return new ScmRepository(this.getQualifiedName(), (Table<ScmRepositoryRecord>)(this.aliased() ? this : null), null, condition);
    }

    public ScmRepository where(Collection<? extends Condition> conditions) {
        return this.where(DSL.and(conditions));
    }

    public ScmRepository where(Condition ... conditions) {
        return this.where(DSL.and((Condition[])conditions));
    }

    public ScmRepository where(Field<Boolean> condition) {
        return this.where(DSL.condition(condition));
    }

    @PlainSQL
    public ScmRepository where(SQL condition) {
        return this.where(DSL.condition((SQL)condition));
    }

    @PlainSQL
    public ScmRepository where(String condition) {
        return this.where(DSL.condition((String)condition));
    }

    @PlainSQL
    public ScmRepository where(String condition, Object ... binds) {
        return this.where(DSL.condition((String)condition, (Object[])binds));
    }

    @PlainSQL
    public ScmRepository where(String condition, QueryPart ... parts) {
        return this.where(DSL.condition((String)condition, (QueryPart[])parts));
    }

    public ScmRepository whereExists(Select<?> select) {
        return this.where(DSL.exists(select));
    }

    public ScmRepository whereNotExists(Select<?> select) {
        return this.where(DSL.notExists(select));
    }

    public static class ScmRepositoryPath
    extends ScmRepository
    implements Path<ScmRepositoryRecord> {
        private static final long serialVersionUID = 1L;

        public <O extends Record> ScmRepositoryPath(Table<O> path, ForeignKey<O, ScmRepositoryRecord> childPath, InverseForeignKey<O, ScmRepositoryRecord> parentPath) {
            super(path, childPath, parentPath);
        }

        private ScmRepositoryPath(Name alias, Table<ScmRepositoryRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public ScmRepositoryPath as(String alias) {
            return new ScmRepositoryPath(DSL.name((String)alias), (Table<ScmRepositoryRecord>)this);
        }

        @Override
        public ScmRepositoryPath as(Name alias) {
            return new ScmRepositoryPath(alias, (Table<ScmRepositoryRecord>)this);
        }

        @Override
        public ScmRepositoryPath as(Table<?> alias) {
            return new ScmRepositoryPath(alias.getQualifiedName(), (Table<ScmRepositoryRecord>)this);
        }
    }
}

