/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.HighLevelRequirement;
import org.squashtest.tm.jooq.domain.tables.RequirementLibraryNode;
import org.squashtest.tm.jooq.domain.tables.RequirementSyncExtender;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.jooq.domain.tables.records.RequirementRecord;

public class Requirement
extends TableImpl<RequirementRecord> {
    private static final long serialVersionUID = 1L;
    public static final Requirement REQUIREMENT = new Requirement();
    public final TableField<RequirementRecord, Long> RLN_ID = Requirement.createField((Name)DSL.name((String)"RLN_ID"), (DataType)SQLDataType.BIGINT.nullable(false), (Table)this, (String)"cle primaire, qui est aussi une cle etrangere vers la table REQUIREMENT_LIBRARY_NODE. Ne doit donc pas etre autogeneree.");
    public final TableField<RequirementRecord, Long> CURRENT_VERSION_ID = Requirement.createField((Name)DSL.name((String)"CURRENT_VERSION_ID"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"FK to REQUIREMENT_VERSION linking to the requirement's latest version. Should not be null but the column is nullable because of cyclic relationship between the tables.");
    public final TableField<RequirementRecord, String> MODE = Requirement.createField((Name)DSL.name((String)"MODE"), (DataType)SQLDataType.VARCHAR((int)15).defaultValue(DSL.field((SQL)DSL.raw((String)"'NATIVE'"), (DataType)SQLDataType.VARCHAR)), (Table)this, (String)"Says whether a requirement is NATIVE or SYNCHRONIZED");
    public final TableField<RequirementRecord, Long> HIGH_LEVEL_REQUIREMENT_ID = Requirement.createField((Name)DSL.name((String)"HIGH_LEVEL_REQUIREMENT_ID"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"");
    private transient RequirementVersion.RequirementVersionPath _requirementVersion;
    private transient HighLevelRequirement.HighLevelRequirementPath _highLevelRequirement;
    private transient RequirementLibraryNode.RequirementLibraryNodePath _requirementLibraryNode;
    private transient RequirementSyncExtender.RequirementSyncExtenderPath _requirementSyncExtender;

    public Class<RequirementRecord> getRecordType() {
        return RequirementRecord.class;
    }

    private Requirement(Name alias, Table<RequirementRecord> aliased) {
        this(alias, aliased, null, null);
    }

    private Requirement(Name alias, Table<RequirementRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table(), where);
    }

    public Requirement(String alias) {
        this(DSL.name((String)alias), (Table<RequirementRecord>)REQUIREMENT);
    }

    public Requirement(Name alias) {
        this(alias, (Table<RequirementRecord>)REQUIREMENT);
    }

    public Requirement() {
        this(DSL.name((String)"REQUIREMENT"), null);
    }

    public <O extends Record> Requirement(Table<O> path, ForeignKey<O, RequirementRecord> childPath, InverseForeignKey<O, RequirementRecord> parentPath) {
        super(path, childPath, parentPath, (Table)REQUIREMENT);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_REQUIREMENT);
    }

    public UniqueKey<RequirementRecord> getPrimaryKey() {
        return Keys.PK_REQUIREMENT;
    }

    public List<ForeignKey<RequirementRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_REQUIREMENT_CURRENT_VERSION, Keys.FK_REQUIREMENT_HIGH_LVL_REQUIREMENT, Keys.FK_REQUIREMENT_REQUIREMENT_NODE);
    }

    public RequirementVersion.RequirementVersionPath requirementVersion() {
        if (this._requirementVersion == null) {
            this._requirementVersion = new RequirementVersion.RequirementVersionPath(this, Keys.FK_REQUIREMENT_CURRENT_VERSION, null);
        }
        return this._requirementVersion;
    }

    public HighLevelRequirement.HighLevelRequirementPath highLevelRequirement() {
        if (this._highLevelRequirement == null) {
            this._highLevelRequirement = new HighLevelRequirement.HighLevelRequirementPath(this, Keys.FK_REQUIREMENT_HIGH_LVL_REQUIREMENT, null);
        }
        return this._highLevelRequirement;
    }

    public RequirementLibraryNode.RequirementLibraryNodePath requirementLibraryNode() {
        if (this._requirementLibraryNode == null) {
            this._requirementLibraryNode = new RequirementLibraryNode.RequirementLibraryNodePath(this, Keys.FK_REQUIREMENT_REQUIREMENT_NODE, null);
        }
        return this._requirementLibraryNode;
    }

    public RequirementSyncExtender.RequirementSyncExtenderPath requirementSyncExtender() {
        if (this._requirementSyncExtender == null) {
            this._requirementSyncExtender = new RequirementSyncExtender.RequirementSyncExtenderPath(this, null, Keys.FK_SYNC_EXTENDER_REQUIREMENT.getInverseKey());
        }
        return this._requirementSyncExtender;
    }

    public Requirement as(String alias) {
        return new Requirement(DSL.name((String)alias), (Table<RequirementRecord>)this);
    }

    public Requirement as(Name alias) {
        return new Requirement(alias, (Table<RequirementRecord>)this);
    }

    public Requirement as(Table<?> alias) {
        return new Requirement(alias.getQualifiedName(), (Table<RequirementRecord>)this);
    }

    public Requirement rename(String name) {
        return new Requirement(DSL.name((String)name), null);
    }

    public Requirement rename(Name name) {
        return new Requirement(name, null);
    }

    public Requirement rename(Table<?> name) {
        return new Requirement(name.getQualifiedName(), null);
    }

    public Requirement where(Condition condition) {
        return new Requirement(this.getQualifiedName(), (Table<RequirementRecord>)(this.aliased() ? this : null), null, condition);
    }

    public Requirement where(Collection<? extends Condition> conditions) {
        return this.where(DSL.and(conditions));
    }

    public Requirement where(Condition ... conditions) {
        return this.where(DSL.and((Condition[])conditions));
    }

    public Requirement where(Field<Boolean> condition) {
        return this.where(DSL.condition(condition));
    }

    @PlainSQL
    public Requirement where(SQL condition) {
        return this.where(DSL.condition((SQL)condition));
    }

    @PlainSQL
    public Requirement where(String condition) {
        return this.where(DSL.condition((String)condition));
    }

    @PlainSQL
    public Requirement where(String condition, Object ... binds) {
        return this.where(DSL.condition((String)condition, (Object[])binds));
    }

    @PlainSQL
    public Requirement where(String condition, QueryPart ... parts) {
        return this.where(DSL.condition((String)condition, (QueryPart[])parts));
    }

    public Requirement whereExists(Select<?> select) {
        return this.where(DSL.exists(select));
    }

    public Requirement whereNotExists(Select<?> select) {
        return this.where(DSL.notExists(select));
    }

    public static class RequirementPath
    extends Requirement
    implements Path<RequirementRecord> {
        private static final long serialVersionUID = 1L;

        public <O extends Record> RequirementPath(Table<O> path, ForeignKey<O, RequirementRecord> childPath, InverseForeignKey<O, RequirementRecord> parentPath) {
            super(path, childPath, parentPath);
        }

        private RequirementPath(Name alias, Table<RequirementRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public RequirementPath as(String alias) {
            return new RequirementPath(DSL.name((String)alias), (Table<RequirementRecord>)this);
        }

        @Override
        public RequirementPath as(Name alias) {
            return new RequirementPath(alias, (Table<RequirementRecord>)this);
        }

        @Override
        public RequirementPath as(Table<?> alias) {
            return new RequirementPath(alias.getQualifiedName(), (Table<RequirementRecord>)this);
        }
    }
}

