/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jooq.domain.tables;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.InverseForeignKey;
import org.jooq.Name;
import org.jooq.Path;
import org.jooq.PlainSQL;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;
import org.squashtest.tm.jooq.domain.Indexes;
import org.squashtest.tm.jooq.domain.Keys;
import org.squashtest.tm.jooq.domain.Public;
import org.squashtest.tm.jooq.domain.tables.InfoList;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.records.InfoListItemRecord;

public class InfoListItem
extends TableImpl<InfoListItemRecord> {
    private static final long serialVersionUID = 1L;
    public static final InfoListItem INFO_LIST_ITEM = new InfoListItem();
    public final TableField<InfoListItemRecord, Long> ITEM_ID = InfoListItem.createField((Name)DSL.name((String)"ITEM_ID"), (DataType)SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field((SQL)DSL.raw((String)"NEXT VALUE FOR \"PUBLIC\".\"INFO_LIST_ITEM_ITEM_ID_SEQ\""), (DataType)SQLDataType.BIGINT)), (Table)this, (String)"");
    public final TableField<InfoListItemRecord, String> ITEM_TYPE = InfoListItem.createField((Name)DSL.name((String)"ITEM_TYPE"), (DataType)SQLDataType.VARCHAR((int)3).nullable(false), (Table)this, (String)"discriminator telling whether this item is user-made or builtin in the app. Pick one of 'USR' or 'SYS'");
    public final TableField<InfoListItemRecord, Long> LIST_ID = InfoListItem.createField((Name)DSL.name((String)"LIST_ID"), (DataType)SQLDataType.BIGINT, (Table)this, (String)"foreign key to the list this item belongs to. Allows 'NULL' for Hibernate to work.");
    public final TableField<InfoListItemRecord, Integer> ITEM_INDEX = InfoListItem.createField((Name)DSL.name((String)"ITEM_INDEX"), (DataType)SQLDataType.INTEGER, (Table)this, (String)"the position of that item in the list. Allows 'NULL' for Hibernate to work.");
    public final TableField<InfoListItemRecord, String> LABEL = InfoListItem.createField((Name)DSL.name((String)"LABEL"), (DataType)SQLDataType.VARCHAR((int)100).nullable(false), (Table)this, (String)"a label to be displayed. If the item is builtin this label will be a i18n key, else the label will be displayed verbatim");
    public final TableField<InfoListItemRecord, String> CODE = InfoListItem.createField((Name)DSL.name((String)"CODE"), (DataType)SQLDataType.VARCHAR((int)30).nullable(false), (Table)this, (String)"a code that helps identifying that item");
    public final TableField<InfoListItemRecord, Boolean> IS_DEFAULT = InfoListItem.createField((Name)DSL.name((String)"IS_DEFAULT"), (DataType)SQLDataType.BOOLEAN.nullable(false).defaultValue(DSL.field((SQL)DSL.raw((String)"FALSE"), (DataType)SQLDataType.BOOLEAN)), (Table)this, (String)"whether this item is the default item for         its list. Only one item per list should have it true");
    public final TableField<InfoListItemRecord, String> ICON_NAME = InfoListItem.createField((Name)DSL.name((String)"ICON_NAME"), (DataType)SQLDataType.VARCHAR((int)100), (Table)this, (String)"the identifier of the icon to be displayed");
    public final TableField<InfoListItemRecord, String> COLOUR = InfoListItem.createField((Name)DSL.name((String)"COLOUR"), (DataType)SQLDataType.VARCHAR((int)7), (Table)this, (String)"");
    private transient InfoList.InfoListPath _infoList;
    private transient RequirementVersion.RequirementVersionPath _requirementVersion;
    private transient TestCase.TestCasePath _fkTcNature;
    private transient TestCase.TestCasePath _fkTcType;

    public Class<InfoListItemRecord> getRecordType() {
        return InfoListItemRecord.class;
    }

    private InfoListItem(Name alias, Table<InfoListItemRecord> aliased) {
        this(alias, aliased, null, null);
    }

    private InfoListItem(Name alias, Table<InfoListItemRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table(), where);
    }

    public InfoListItem(String alias) {
        this(DSL.name((String)alias), (Table<InfoListItemRecord>)INFO_LIST_ITEM);
    }

    public InfoListItem(Name alias) {
        this(alias, (Table<InfoListItemRecord>)INFO_LIST_ITEM);
    }

    public InfoListItem() {
        this(DSL.name((String)"INFO_LIST_ITEM"), null);
    }

    public <O extends Record> InfoListItem(Table<O> path, ForeignKey<O, InfoListItemRecord> childPath, InverseForeignKey<O, InfoListItemRecord> parentPath) {
        super(path, childPath, parentPath, (Table)INFO_LIST_ITEM);
    }

    public Schema getSchema() {
        return this.aliased() ? null : Public.PUBLIC;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.IDX_INFO_LIST_ITEM_CODE);
    }

    public UniqueKey<InfoListItemRecord> getPrimaryKey() {
        return Keys.PK_INFO_LIST_ITEM;
    }

    public List<UniqueKey<InfoListItemRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.CONSTRAINT_2);
    }

    public List<ForeignKey<InfoListItemRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_INFO_ITEM_LIST);
    }

    public InfoList.InfoListPath infoList() {
        if (this._infoList == null) {
            this._infoList = new InfoList.InfoListPath(this, Keys.FK_INFO_ITEM_LIST, null);
        }
        return this._infoList;
    }

    public RequirementVersion.RequirementVersionPath requirementVersion() {
        if (this._requirementVersion == null) {
            this._requirementVersion = new RequirementVersion.RequirementVersionPath(this, null, Keys.FK_REQ_NATURE.getInverseKey());
        }
        return this._requirementVersion;
    }

    public TestCase.TestCasePath fkTcNature() {
        if (this._fkTcNature == null) {
            this._fkTcNature = new TestCase.TestCasePath(this, null, Keys.FK_TC_NATURE.getInverseKey());
        }
        return this._fkTcNature;
    }

    public TestCase.TestCasePath fkTcType() {
        if (this._fkTcType == null) {
            this._fkTcType = new TestCase.TestCasePath(this, null, Keys.FK_TC_TYPE.getInverseKey());
        }
        return this._fkTcType;
    }

    public InfoListItem as(String alias) {
        return new InfoListItem(DSL.name((String)alias), (Table<InfoListItemRecord>)this);
    }

    public InfoListItem as(Name alias) {
        return new InfoListItem(alias, (Table<InfoListItemRecord>)this);
    }

    public InfoListItem as(Table<?> alias) {
        return new InfoListItem(alias.getQualifiedName(), (Table<InfoListItemRecord>)this);
    }

    public InfoListItem rename(String name) {
        return new InfoListItem(DSL.name((String)name), null);
    }

    public InfoListItem rename(Name name) {
        return new InfoListItem(name, null);
    }

    public InfoListItem rename(Table<?> name) {
        return new InfoListItem(name.getQualifiedName(), null);
    }

    public InfoListItem where(Condition condition) {
        return new InfoListItem(this.getQualifiedName(), (Table<InfoListItemRecord>)(this.aliased() ? this : null), null, condition);
    }

    public InfoListItem where(Collection<? extends Condition> conditions) {
        return this.where(DSL.and(conditions));
    }

    public InfoListItem where(Condition ... conditions) {
        return this.where(DSL.and((Condition[])conditions));
    }

    public InfoListItem where(Field<Boolean> condition) {
        return this.where(DSL.condition(condition));
    }

    @PlainSQL
    public InfoListItem where(SQL condition) {
        return this.where(DSL.condition((SQL)condition));
    }

    @PlainSQL
    public InfoListItem where(String condition) {
        return this.where(DSL.condition((String)condition));
    }

    @PlainSQL
    public InfoListItem where(String condition, Object ... binds) {
        return this.where(DSL.condition((String)condition, (Object[])binds));
    }

    @PlainSQL
    public InfoListItem where(String condition, QueryPart ... parts) {
        return this.where(DSL.condition((String)condition, (QueryPart[])parts));
    }

    public InfoListItem whereExists(Select<?> select) {
        return this.where(DSL.exists(select));
    }

    public InfoListItem whereNotExists(Select<?> select) {
        return this.where(DSL.notExists(select));
    }

    public static class InfoListItemPath
    extends InfoListItem
    implements Path<InfoListItemRecord> {
        private static final long serialVersionUID = 1L;

        public <O extends Record> InfoListItemPath(Table<O> path, ForeignKey<O, InfoListItemRecord> childPath, InverseForeignKey<O, InfoListItemRecord> parentPath) {
            super(path, childPath, parentPath);
        }

        private InfoListItemPath(Name alias, Table<InfoListItemRecord> aliased) {
            super(alias, aliased);
        }

        @Override
        public InfoListItemPath as(String alias) {
            return new InfoListItemPath(DSL.name((String)alias), (Table<InfoListItemRecord>)this);
        }

        @Override
        public InfoListItemPath as(Name alias) {
            return new InfoListItemPath(alias, (Table<InfoListItemRecord>)this);
        }

        @Override
        public InfoListItemPath as(Table<?> alias) {
            return new InfoListItemPath(alias.getQualifiedName(), (Table<InfoListItemRecord>)this);
        }
    }
}

