/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.infrastructure.hibernate;

import java.util.Locale;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;

public class UppercaseUnderscorePhysicalNaming
implements PhysicalNamingStrategy {
    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return this.apply(name);
    }

    private Identifier apply(Identifier name) {
        if (name == null) {
            return null;
        }
        String shortName = name.getText();
        shortName = shortName.substring(shortName.lastIndexOf(46) + 1);
        StringBuilder text = new StringBuilder(shortName);
        int i = 1;
        while (i < text.length() - 1) {
            if (this.isUnderscoreRequired(text.charAt(i - 1), text.charAt(i), text.charAt(i + 1))) {
                text.insert(i, '_');
                i += 2;
                continue;
            }
            ++i;
        }
        int lastIndex = text.length() - 1;
        if (this.isUnderscoreRequired(text.charAt(lastIndex - 1), text.charAt(lastIndex))) {
            text.insert(lastIndex, '_');
        }
        return new Identifier(text.toString().toUpperCase(Locale.ROOT), name.isQuoted());
    }

    private boolean isUnderscoreRequired(char before, char current, char after) {
        return before != '_' && Character.isLowerCase(before) && Character.isUpperCase(current) || Character.isUpperCase(current) && Character.isLowerCase(after);
    }

    private boolean isUnderscoreRequired(char before, char current) {
        return before != '_' && Character.isLowerCase(before) && Character.isUpperCase(current);
    }
}

