/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception.customfield;

import org.squashtest.tm.exception.DomainException;

public class CodeAlreadyExistsException
extends DomainException {
    private static final long serialVersionUID = -4211676654109306608L;
    private static final String CODE = "code";
    private static final String KEY = "sqtm-core.error.generic.duplicate-code";

    public CodeAlreadyExistsException(String oldCode, String newCode, Class<?> holder) {
        super(CodeAlreadyExistsException.makeMessage(oldCode, newCode, holder.getCanonicalName()), CODE);
    }

    public CodeAlreadyExistsException() {
        super(CODE);
    }

    public CodeAlreadyExistsException(String message) {
        super(message, CODE);
    }

    private static String makeMessage(String oldCode, String newCode, String holder) {
        if (oldCode == null || oldCode.equals(newCode)) {
            return "Cannot create the " + holder + " of code :'" + newCode + "' because this code is already used by another " + holder + ".";
        }
        return "Cannot change code '" + oldCode + "' for '" + newCode + "' this code is already used by another " + holder + ".";
    }

    @Override
    public String getI18nKey() {
        return KEY;
    }
}

