/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.exception;

import org.squashtest.tm.exception.DomainException;

public class DuplicateNameException
extends DomainException {
    private static final String NAME = "name";
    private static final long serialVersionUID = 2815263509542519285L;

    public DuplicateNameException(String oldName, String newName) {
        super(DuplicateNameException.makeMessage(oldName, newName), NAME);
        this.setFieldValue(newName);
    }

    public DuplicateNameException(String oldName, String newName, String fieldValue) {
        super(DuplicateNameException.makeMessage(oldName, newName), NAME, fieldValue);
    }

    public DuplicateNameException() {
        super(NAME);
    }

    public DuplicateNameException(String message) {
        super(message, NAME);
    }

    private static String makeMessage(String oldName, String newName) {
        return "Cannot rename " + oldName + " : " + newName + " already exists within the same container";
    }

    @Override
    public String getI18nKey() {
        return "sqtm-core.error.generic.duplicate-name";
    }
}

