/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Set;

@Entity
@Table(name="CORE_GROUP")
public class UsersGroup {
    public static final String USER = "squashtest.authz.group.tm.User";
    public static final String ADMIN = "squashtest.authz.group.core.Admin";
    public static final String TEST_AUTOMATION_SERVER = "squashtest.authz.group.tm.TestAutomationServer";
    public static final String INFRASTRUCTURE_ADMIN = "squashtest.authz.group.tm.InfrastructureAdmin";
    public static final Set<String> ASSIGNABLE_USER_GROUPS = Set.of("squashtest.authz.group.core.Admin", "squashtest.authz.group.tm.User", "squashtest.authz.group.tm.TestAutomationServer");
    public static final Set<String> MODIFIABLE_USER_GROUPS = Set.of("squashtest.authz.group.core.Admin", "squashtest.authz.group.tm.User");
    public static final Set<String> TECHNICAL_USER_GROUPS = Set.of("squashtest.authz.group.tm.TestAutomationServer", "squashtest.authz.group.tm.InfrastructureAdmin");
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="core_group_id_seq")
    @SequenceGenerator(name="core_group_id_seq", sequenceName="core_group_id_seq", allocationSize=1)
    private Long id;
    private String qualifiedName;
    private transient String simpleName;

    public UsersGroup(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public UsersGroup() {
        if (this.qualifiedName != null) {
            this.calculateSimpleName();
        }
    }

    public String getSimpleName() {
        this.calculateSimpleName();
        return this.simpleName;
    }

    private void calculateSimpleName() {
        this.simpleName = this.qualifiedName.substring(this.qualifiedName.lastIndexOf(46) + 1);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public Long getId() {
        return this.id;
    }
}

