/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.AccessDeniedException;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.AuditableSupport;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayReference;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.Team;

@Entity
@Auditable
@Table(name="CORE_USER")
@PrimaryKeyJoinColumn(name="PARTY_ID")
public class User
extends Party {
    private static final String TYPE = "USER";
    public static final String INFRASTRUCTURE_ADMIN_LOGIN = "squash-cloud-admin";
    @Transient
    public static final Long NO_USER_ID = 0L;
    @NotNull
    @Size(max=50)
    private @NotNull @Size(max=50) String firstName = "";
    @NotBlank
    @Size(max=50)
    private @NotBlank @Size(max=50) String lastName;
    @NotBlank
    @Size(max=100)
    private @NotBlank @Size(max=100) String login;
    @NotNull
    @Size(max=255)
    private @NotNull @Size(max=255) String email = "";
    private Boolean active = true;
    @Column(insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastConnectedOn;
    @NotNull
    @ManyToMany(mappedBy="members")
    private final Set<Team> teams = new HashSet<Team>();
    @Embedded
    private AuditableSupport audit = new AuditableSupport();
    @NotNull
    private boolean canDeleteFromFront = true;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private List<GridColumnDisplayReference> gridReferences;

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login.trim();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setLastConnectedOn(Date lastConnectedOn) {
        this.lastConnectedOn = lastConnectedOn;
    }

    public Date getLastConnectedOn() {
        return this.lastConnectedOn;
    }

    @Override
    public Date getCreatedOn() {
        return this.audit.getCreatedOn();
    }

    @Override
    public String getCreatedBy() {
        return this.audit.getCreatedBy();
    }

    @Override
    public Date getLastModifiedOn() {
        return this.audit.getLastModifiedOn();
    }

    @Override
    public String getLastModifiedBy() {
        return this.audit.getLastModifiedBy();
    }

    @Override
    public boolean isSkipModifyAudit() {
        return this.audit.isSkipModifyAudit();
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.audit.setCreatedBy(createdBy);
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.audit.setCreatedOn(createdOn);
    }

    @Override
    public void setLastModifiedBy(String lastModifiedBy) {
        this.audit.setLastModifiedBy(lastModifiedBy);
    }

    @Override
    public void setLastModifiedOn(Date lastModifiedOn) {
        this.audit.setLastModifiedOn(lastModifiedOn);
    }

    @Override
    public void setSkipModifyAudit(boolean skipModifyAudit) {
        this.audit.setSkipModifyAudit(skipModifyAudit);
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void addTeam(Team team) {
        this.teams.add(team);
    }

    public void removeTeams(Collection<Long> teamIds) {
        Iterator<Team> iterator = this.teams.iterator();
        while (iterator.hasNext()) {
            Team team = iterator.next();
            if (!teamIds.contains(team.getId())) continue;
            team.removeMember(this);
            iterator.remove();
        }
    }

    @Override
    public String getName() {
        return this.appendFullName(new StringBuilder()).append(" (").append(this.login).append(")").toString();
    }

    private StringBuilder appendFullName(StringBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)this.firstName)) {
            builder.append(this.firstName).append(' ');
        }
        builder.append(this.lastName);
        return builder;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void accept(PartyVisitor visitor) {
        visitor.visit(this);
    }

    public static User createFromLogin(@NotNull String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        User user = new User();
        user.login = login;
        user.normalize();
        return user;
    }

    public static User createInfrastructureAdmin() {
        User user = new User();
        user.login = INFRASTRUCTURE_ADMIN_LOGIN;
        user.normalize();
        return user;
    }

    public boolean loginIs(String candidate) {
        return StringUtils.equals((CharSequence)this.login, (CharSequence)candidate);
    }

    public void normalize() {
        if (StringUtils.isBlank((CharSequence)this.lastName)) {
            this.lastName = this.login;
        }
        this.firstName = this.firstName != null ? this.firstName : "";
        this.email = this.email != null ? this.email : "";
        this.active = this.active == null || this.active != false;
    }

    public boolean isCanDeleteFromFront() {
        return this.canDeleteFromFront;
    }

    public void setCanDeleteFromFront(boolean canDeleteFromFront) {
        this.canDeleteFromFront = canDeleteFromFront;
    }

    public List<GridColumnDisplayReference> getGridReferences() {
        return this.gridReferences;
    }

    public void setGridReferences(List<GridColumnDisplayReference> gridReferences) {
        this.gridReferences = gridReferences;
    }

    public boolean isInfrastructureAdmin() {
        return this.loginIs(INFRASTRUCTURE_ADMIN_LOGIN) && this.isFromInfrastructureAdminGroup();
    }

    public boolean isFromInfrastructureAdminGroup() {
        return this.getGroup() != null && "squashtest.authz.group.tm.InfrastructureAdmin".equals(this.getGroup().getQualifiedName());
    }

    public void checkIsNotFromInfrastructureAdminGroup() {
        if (this.isFromInfrastructureAdminGroup()) {
            throw new AccessDeniedException("Cannot manage a user from infrastructure admin group.");
        }
    }
}

