/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.users;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.List;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.PartyVisitor;
import org.squashtest.tm.domain.users.UsersGroup;

@Entity
@Table(name="CORE_PARTY")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Party
implements Identified,
AuditableMixin {
    private static final String TYPE = "PARTY";
    @Id
    @Column(name="PARTY_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="core_party_party_id_seq")
    @SequenceGenerator(name="core_party_party_id_seq", sequenceName="core_party_party_id_seq", allocationSize=1)
    protected Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinTable(name="CORE_GROUP_MEMBER", joinColumns={@JoinColumn(name="PARTY_ID")}, inverseJoinColumns={@JoinColumn(name="GROUP_ID")})
    private UsersGroup group;
    @OneToMany(mappedBy="party", cascade={CascadeType.REMOVE})
    private List<PartyPreference> preferences;

    public UsersGroup getGroup() {
        return this.group;
    }

    public void setGroup(UsersGroup group) {
        this.group = group;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public String getName() {
        return "";
    }

    public String getType() {
        return TYPE;
    }

    public abstract void accept(PartyVisitor var1);
}

