/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.FolderSupport;
import org.squashtest.tm.domain.library.NodeContainerVisitor;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TCLN_ID")
public class TestCaseFolder
extends TestCaseLibraryNode
implements Folder<TestCaseLibraryNode> {
    private static final String CLASS_NAME = "org.squashtest.tm.domain.testcase.TestCaseFolder";
    private static final String SIMPLE_CLASS_NAME = "TestCaseFolder";
    @Transient
    private final FolderSupport<TestCaseLibraryNode, TestCaseFolder> folderSupport = new FolderSupport(this);
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @OrderColumn(name="CONTENT_ORDER")
    @JoinTable(name="TCLN_RELATIONSHIP", joinColumns={@JoinColumn(name="ANCESTOR_ID")}, inverseJoinColumns={@JoinColumn(name="DESCENDANT_ID")})
    private List<TestCaseLibraryNode> content = new ArrayList<TestCaseLibraryNode>();

    @Override
    public void addContent(TestCaseLibraryNode node) {
        TestCaseLibraryNode testCaseLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseLibraryNode);
        this.folderSupport.addContent(node);
    }

    @Override
    public void addContent(TestCaseLibraryNode node, int position) {
        TestCaseLibraryNode testCaseLibraryNode = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCaseLibraryNode);
        this.folderSupport.addContent(node, position);
        this.content = new ArrayList<TestCaseLibraryNode>(this.content);
    }

    @Override
    public List<TestCaseLibraryNode> getContent() {
        return this.content;
    }

    @Override
    public void accept(TestCaseLibraryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(NodeContainerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isContentNameAvailable(String name) {
        return this.folderSupport.isContentNameAvailable(name);
    }

    @Override
    public void removeContent(TestCaseLibraryNode node) throws NullArgumentException {
        this.content.remove(node);
        this.content = new ArrayList<TestCaseLibraryNode>(this.content);
    }

    @Override
    public TestCaseFolder createCopy() {
        return this.folderSupport.createCopy(new TestCaseFolder());
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        GenericProject former = this.getProject();
        super.notifyAssociatedWithProject(project);
        this.folderSupport.notifyAssociatedProjectWasSet((Project)former, project);
    }

    @Override
    public String getClassSimpleName() {
        return SIMPLE_CLASS_NAME;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean hasContent() {
        return this.folderSupport.hasContent();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getContentNames() {
        return this.folderSupport.getContentNames();
    }

    @Override
    public Collection<TestCaseLibraryNode> getOrderedContent() {
        return this.content;
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TESTCASE_FOLDER;
    }

    @Override
    public EntityReference toEntityReference() {
        return new EntityReference(EntityType.TEST_CASE_FOLDER, this.getId());
    }
}

