/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.exception.testcase.StepDoesNotBelongToTestCaseException;

@NamedQueries(value={@NamedQuery(name="RequirementVersionCoverage.byRequirementVersionAndTestCase", query="select rvc from RequirementVersionCoverage rvc join rvc.verifiedRequirementVersion rv join rvc.verifyingTestCase tc where rv.id = :rvId and tc.id = :tcId"), @NamedQuery(name="RequirementVersionCoverage.numberByTestCase", query="select count(rvc) from RequirementVersionCoverage rvc join rvc.verifyingTestCase tc where tc.id = :tcId"), @NamedQuery(name="RequirementVersionCoverage.numberByTestCases", query="select count(rvc) from RequirementVersionCoverage rvc join rvc.verifyingTestCase tc where tc.id in :tcIds"), @NamedQuery(name="RequirementVersionCoverage.numberDistinctVerifiedByTestCases", query="select count(distinct rv) from RequirementVersionCoverage rvc join rvc.verifiedRequirementVersion rv join rvc.verifyingTestCase tc where tc.id in :tcIds")})
@Entity
public class RequirementVersionCoverage
implements Identified,
RelatedToAuditable {
    @Id
    @Column(name="REQUIREMENT_VERSION_COVERAGE_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="requirement_version_coverage_requirement_version_coverage_i_seq")
    @SequenceGenerator(name="requirement_version_coverage_requirement_version_coverage_i_seq", sequenceName="requirement_version_coverage_requirement_version_coverage_i_seq", allocationSize=30)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="VERIFYING_TEST_CASE_ID", referencedColumnName="TCLN_ID")
    private TestCase verifyingTestCase;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="VERIFIED_REQ_VERSION_ID", referencedColumnName="RES_ID")
    private RequirementVersion verifiedRequirementVersion;
    @NotNull
    @ManyToMany(mappedBy="requirementVersionCoverages", cascade={CascadeType.DETACH})
    private Set<ActionTestStep> verifyingSteps = new HashSet<ActionTestStep>();

    RequirementVersionCoverage() {
    }

    public RequirementVersionCoverage(RequirementVersion verifiedRequirementVersion) {
        this(verifiedRequirementVersion, null);
    }

    public RequirementVersionCoverage(RequirementVersion requirementVersion, TestCase testCase) {
        this(requirementVersion, testCase, true);
    }

    public RequirementVersionCoverage(Requirement requirement, TestCase testCase) {
        this(requirement.getCurrentVersion(), testCase);
    }

    public RequirementVersionCoverage(RequirementVersion requirementVersion, TestCase testCase, boolean performStatusCheck) {
        if (performStatusCheck) {
            requirementVersion.checkLinkable();
        }
        if (testCase != null) {
            testCase.checkRequirementNotVerified(requirementVersion);
        }
        this.verifiedRequirementVersion = requirementVersion;
        this.verifiedRequirementVersion.addRequirementCoverage(this);
        if (testCase != null) {
            testCase.addRequirementCoverage(this);
            this.verifyingTestCase = testCase;
        }
    }

    public TestCase getVerifyingTestCase() {
        return this.verifyingTestCase;
    }

    public void setVerifyingTestCase(TestCase verifyingTestCase) {
        if (this.verifiedRequirementVersion != null) {
            verifyingTestCase.checkRequirementNotVerified(this, this.verifiedRequirementVersion);
        }
        this.verifyingTestCase = verifyingTestCase;
    }

    public RequirementVersion getVerifiedRequirementVersion() {
        return this.verifiedRequirementVersion;
    }

    public void setVerifiedRequirementVersion(RequirementVersion verifiedRequirementVersion) {
        if (this.verifyingTestCase != null && this.verifiedRequirementVersion != null) {
            this.verifyingTestCase.checkRequirementNotVerified(this, verifiedRequirementVersion);
        }
        verifiedRequirementVersion.checkLinkable();
        this.verifiedRequirementVersion = verifiedRequirementVersion;
        verifiedRequirementVersion.addRequirementCoverage(this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Set<ActionTestStep> getVerifyingSteps() {
        return this.verifyingSteps;
    }

    public void addAllVerifyingSteps(Collection<ActionTestStep> steps) {
        this.checkStepsBelongToTestCase(steps);
        this.verifyingSteps.addAll(steps);
        for (ActionTestStep step : steps) {
            step.addRequirementVersionCoverage(this);
        }
    }

    private void checkStepsBelongToTestCase(Collection<ActionTestStep> steps) {
        for (ActionTestStep step : steps) {
            if (this.verifyingTestCase.hasStep(step)) continue;
            throw new StepDoesNotBelongToTestCaseException(this.verifyingTestCase.getId(), step.getId());
        }
    }

    public RequirementVersionCoverage copyForRequirementVersion(RequirementVersion rvCopy) {
        RequirementVersionCoverage rvcCopy = new RequirementVersionCoverage();
        rvcCopy.verifyingTestCase = this.verifyingTestCase;
        rvcCopy.verifiedRequirementVersion = rvCopy;
        rvcCopy.verifyingSteps.addAll(this.verifyingSteps);
        return rvcCopy;
    }

    public RequirementVersionCoverage copyForTestCase(TestCase tcCopy) {
        if (!this.verifiedRequirementVersion.isLinkable()) {
            return null;
        }
        RequirementVersionCoverage rvcCopy = new RequirementVersionCoverage();
        rvcCopy.verifiedRequirementVersion = this.verifiedRequirementVersion;
        rvcCopy.setVerifyingTestCase(tcCopy);
        tcCopy.addRequirementCoverage(rvcCopy);
        ArrayList<ActionTestStep> stepToVerify = new ArrayList<ActionTestStep>(this.verifyingSteps.size());
        for (ActionTestStep step : this.verifyingSteps) {
            int indexInSource = this.verifyingTestCase.getPositionOfStep(step.getId());
            stepToVerify.add((ActionTestStep)tcCopy.getSteps().get(indexInSource));
        }
        rvcCopy.addAllVerifyingSteps(stepToVerify);
        return rvcCopy;
    }

    public void checkCanRemoveTestCaseFromRequirementVersion() {
        this.verifiedRequirementVersion.checkLinkable();
    }

    public boolean hasStepAsVerifying(long stepId) {
        for (ActionTestStep step : this.verifyingSteps) {
            if (!step.getId().equals(stepId)) continue;
            return true;
        }
        return false;
    }

    public void removeVerifyingStep(long testStepId) {
        Iterator<ActionTestStep> iterator = this.verifyingSteps.iterator();
        while (iterator.hasNext()) {
            ActionTestStep step = iterator.next();
            if (!step.getId().equals(testStepId)) continue;
            iterator.remove();
        }
    }

    public boolean hasSteps() {
        return !this.verifyingSteps.isEmpty();
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Arrays.asList(this.verifyingTestCase, this.verifiedRequirementVersion);
    }
}

