/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;

@Entity
public class DatasetParamValue
implements Identified,
RelatedToAuditable {
    @Id
    @Column(name="DATASET_PARAM_VALUE_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="dataset_param_value_dataset_param_value_id_seq")
    @SequenceGenerator(name="dataset_param_value_dataset_param_value_id_seq", sequenceName="dataset_param_value_dataset_param_value_id_seq", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PARAM_ID", referencedColumnName="PARAM_ID")
    private Parameter parameter;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DATASET_ID", referencedColumnName="DATASET_ID")
    private Dataset dataset;
    @NotNull
    @Size(max=1024)
    private @NotNull @Size(max=1024) String paramValue = "";

    public DatasetParamValue() {
    }

    public DatasetParamValue(Parameter parameter, Dataset dataset) {
        this();
        this.parameter = parameter;
        this.dataset = dataset;
        this.dataset.addParameterValue(this);
    }

    public DatasetParamValue(Parameter parameter, Dataset dataset, String paramValue) {
        this(parameter, dataset);
        this.paramValue = paramValue;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return this.parameter.getAssociatedAuditableList();
    }
}

