/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "TEST_CASE_ID"})})
public class Dataset
implements Identified,
RelatedToAuditable {
    @Id
    @Column(name="DATASET_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="dataset_dataset_id_seq")
    @SequenceGenerator(name="dataset_dataset_id_seq", sequenceName="dataset_dataset_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_CASE_ID", referencedColumnName="TCLN_ID")
    private TestCase testCase;
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="dataset")
    private Set<DatasetParamValue> parameterValues = new HashSet<DatasetParamValue>(0);

    public Dataset() {
    }

    public Dataset(String name, @NotNull TestCase testCase) {
        this.name = name;
        this.testCase = testCase;
        this.testCase.addDataset(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        this.testCase = testCase;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Set<DatasetParamValue> getParameterValues() {
        return Collections.unmodifiableSet(this.parameterValues);
    }

    public void addParameterValue(@NotNull DatasetParamValue datasetParamValue) {
        DatasetParamValue datasetParamValue2 = datasetParamValue;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)datasetParamValue2);
        this.parameterValues.add(datasetParamValue);
    }

    public void removeParameterValue(@NotNull DatasetParamValue datasetParamValue) {
        DatasetParamValue datasetParamValue2 = datasetParamValue;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)datasetParamValue2);
        this.parameterValues.remove(datasetParamValue);
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        return Collections.singletonList(this.testCase);
    }

    public DatasetParamValue findDatasetParamValue(Parameter parameter) {
        for (DatasetParamValue datasetParamValue : this.parameterValues) {
            if (!datasetParamValue.getParameter().equals(parameter)) continue;
            return datasetParamValue;
        }
        return null;
    }
}

