/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testcase;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.context.MessageSource;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.domain.testcase.TestStepVisitor;

@Entity
@PrimaryKeyJoinColumn(name="TEST_STEP_ID")
@NamedQuery(name="ActionTestSteps.fetchWithAttachmentReferences", query="select distinct step from ActionTestStep step inner join fetch step.attachmentList attachmentList left join fetch attachmentList.attachments attachements where step.testCase.id in (:testCaseIds)")
public class ActionTestStep
extends TestStep
implements BoundEntity,
AttachmentHolder {
    @Lob
    @JdbcTypeCode(value=-1)
    @NotNull
    private String action = "";
    @Lob
    @JdbcTypeCode(value=-1)
    @NotNull
    private String expectedResult = "";
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REMOVE})
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinTable(name="VERIFYING_STEPS", joinColumns={@JoinColumn(name="TEST_STEP_ID")}, inverseJoinColumns={@JoinColumn(name="REQUIREMENT_VERSION_COVERAGE_ID")})
    private Set<RequirementVersionCoverage> requirementVersionCoverages = new HashSet<RequirementVersionCoverage>();

    public ActionTestStep() {
    }

    public ActionTestStep(String action, String expectedResult) {
        this.action = action;
        this.expectedResult = expectedResult;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    @Override
    public ActionTestStep createCopy() {
        ActionTestStep newTestStep = new ActionTestStep();
        newTestStep.action = this.action;
        newTestStep.expectedResult = this.expectedResult;
        newTestStep.setTestCase(this.getTestCase());
        for (Attachment tcAttach : this.getAttachmentList().getAllAttachments()) {
            Attachment clone = tcAttach.shallowCopy();
            newTestStep.getAttachmentList().addAttachment(clone);
        }
        return newTestStep;
    }

    @Override
    public void accept(TestStepVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setTestCase(@NotNull TestCase testCase) {
        TestCase testCase2 = testCase;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)testCase2);
        if (!TestCaseKind.STANDARD.equals((Object)testCase.getKind())) {
            throw new IllegalArgumentException("Cannot add an Action Test Step outside a Test Case");
        }
        super.setTestCase(testCase);
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    @Override
    public List<ExecutionStep> createExecutionSteps(Dataset dataset, MessageSource messageSource, Locale locale) {
        ArrayList<ExecutionStep> returnList = new ArrayList<ExecutionStep>(1);
        ExecutionStep exec = new ExecutionStep(this, dataset);
        returnList.add(exec);
        return returnList;
    }

    public Set<Attachment> getAllAttachments() {
        return this.attachmentList.getAllAttachments();
    }

    @Override
    public Long getBoundEntityId() {
        return this.getId();
    }

    @Override
    public BindableEntity getBoundEntityType() {
        return BindableEntity.TEST_STEP;
    }

    @Override
    public Project getProject() {
        return this.getTestCase().getProject();
    }

    public void removeRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.remove(requirementVersionCoverage);
    }

    public Set<RequirementVersionCoverage> getRequirementVersionCoverages() {
        return Collections.unmodifiableSet(this.requirementVersionCoverages);
    }

    public void addRequirementVersionCoverage(RequirementVersionCoverage requirementVersionCoverage) {
        this.requirementVersionCoverages.add(requirementVersionCoverage);
    }

    public Set<RequirementVersion> getVerifiedRequirementVersions() {
        HashSet<RequirementVersion> verified = new HashSet<RequirementVersion>();
        for (RequirementVersionCoverage coverage : this.requirementVersionCoverages) {
            verified.add(coverage.getVerifiedRequirementVersion());
        }
        return Collections.unmodifiableSet(verified);
    }

    public Set<String> findUsedParametersNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.action != null) {
            result.addAll(Parameter.findUsedParameterNamesInString(this.action));
        }
        if (this.expectedResult != null) {
            result.addAll(Parameter.findUsedParameterNamesInString(this.expectedResult));
        }
        return result;
    }

    public static ActionTestStep createBlankActionStep() {
        return new ActionTestStep("", "");
    }
}

