/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.validator.constraints.URL;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTag;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;

@NamedQueries(value={@NamedQuery(name="testAutomationServer.findAllHostedProjects", query="select p from TestAutomationProject p join p.server s where s.id = :serverId"), @NamedQuery(name="testAutomationServer.hasBoundProjects", query="select count(*) from TestAutomationProject where server.id = :serverId"), @NamedQuery(name="testAutomationServer.dereferenceProjects", query="update GenericProject set testAutomationServer = null where testAutomationServer.id = :serverId"), @NamedQuery(name="testAutomationServer.deleteServer", query="delete from TestAutomationServer serv where serv.id = :serverId")})
@Entity
@PrimaryKeyJoinColumn(name="SERVER_ID")
public class TestAutomationServer
extends ThirdPartyServer
implements Identified {
    private static final TestAutomationServerKind DEFAULT_KIND = TestAutomationServerKind.jenkins;
    @Column
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TestAutomationServerKind kind = DEFAULT_KIND;
    @Column(name="MANUAL_SLAVE_SELECTION")
    private boolean manualSlaveSelection = false;
    @ElementCollection
    @CollectionTable(name="AUTOMATION_ENVIRONMENT_TAG", joinColumns={@JoinColumn(name="ENTITY_ID")})
    @SQLRestriction(value="ENTITY_TYPE = 'TEST_AUTOMATION_SERVER'")
    private List<AutomationEnvironmentTag> environmentTags = new ArrayList<AutomationEnvironmentTag>();
    @URL
    @Size(max=255)
    @Column(name="OBSERVER_URL")
    private @URL @Size(max=255) String observerUrl;
    @URL
    @Size(max=255)
    @Column(name="EVENT_BUS_URL")
    private @URL @Size(max=255) String eventBusUrl;
    @URL
    @Size(max=255)
    @Column(name="KILLSWITCH_URL")
    private @URL @Size(max=255) String killswitchUrl;
    @Lob
    @JdbcTypeCode(value=-1)
    private String additionalConfiguration = "";

    public TestAutomationServer() {
    }

    public TestAutomationServer(TestAutomationServerKind kind) {
        this.kind = kind;
    }

    public TestAutomationServerKind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestAutomationServer{");
        sb.append("id=").append(this.getId());
        sb.append(", name='").append(this.getName()).append('\'');
        sb.append(", url='").append(this.getUrl()).append('\'');
        sb.append(", kind='").append((Object)this.kind).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean isManualSlaveSelection() {
        return this.manualSlaveSelection;
    }

    public void setManualSlaveSelection(boolean manualSlaveSelection) {
        this.manualSlaveSelection = manualSlaveSelection;
    }

    public TestAutomationServer createCopy() {
        TestAutomationServer testAutomationServerCopy = new TestAutomationServer(this.getKind());
        testAutomationServerCopy.setName(this.getName());
        testAutomationServerCopy.setUrl(this.getUrl());
        testAutomationServerCopy.setDescription(this.getDescription());
        testAutomationServerCopy.setManualSlaveSelection(this.isManualSlaveSelection());
        return testAutomationServerCopy;
    }

    public List<AutomationEnvironmentTag> getEnvironmentTags() {
        return this.environmentTags;
    }

    public void setEnvironmentTags(List<AutomationEnvironmentTag> environmentTags) {
        this.environmentTags = environmentTags;
    }

    public String getObserverUrl() {
        return this.observerUrl;
    }

    public void setObserverUrl(String observerUrl) {
        this.observerUrl = observerUrl;
    }

    public String getEventBusUrl() {
        return this.eventBusUrl;
    }

    public void setEventBusUrl(String eventBusUrl) {
        this.eventBusUrl = eventBusUrl;
    }

    public String getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    public void setAdditionalConfiguration(String additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration;
    }

    public String getKillswitchUrl() {
        return this.killswitchUrl;
    }

    public void setKillswitchUrl(String killSwitchUrl) {
        this.killswitchUrl = killSwitchUrl;
    }
}

