/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@NamedQueries(value={@NamedQuery(name="testAutomationProject.findHostedProjectIds", query="select project.id from TestAutomationProject project where project.server.id = :serverId"), @NamedQuery(name="testAutomationProject.findAllKnownTests", query="select t from AutomatedTest t join t.project p where p.id = :projectId"), @NamedQuery(name="testAutomationProject.findAllByTMPRoject", query="select tap.id from TestAutomationProject tap join tap.tmProject tmp where tmp.id = :tmProjectId"), @NamedQuery(name="testAutomationProject.haveExecutedTestsByIds", query="select count(ext) from AutomatedExecutionExtender ext join ext.automatedTest test join test.project p where p.id in (:projectIds)"), @NamedQuery(name="testAutomationProject.dereferenceAutomatedExecutionExtender", query="update AutomatedExecutionExtender set resultURL = null, automatedTest = null where automatedTest in (select tests from AutomatedTest tests join tests.project p where p.id in (:projectIds))"), @NamedQuery(name="testAutomationProject.dereferenceTestCases", query="update TestCase set automatedTest = null where automatedTest in (select tests from AutomatedTest tests join tests.project p where p.id in (:projectIds))"), @NamedQuery(name="testAutomationProject.deleteAutomatedTests", query="delete AutomatedTest t where t.project.id in (:projectIds)"), @NamedQuery(name="testAutomationProject.delete", query="delete TestAutomationProject p where p.id in (:projectIds)")})
@Entity
public class TestAutomationProject
implements Identified {
    @Id
    @Column(name="TA_PROJECT_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="proto_test_automation_project_ta_project_id_seq")
    @SequenceGenerator(name="proto_test_automation_project_ta_project_id_seq", sequenceName="proto_test_automation_project_ta_project_id_seq", allocationSize=1)
    private Long id;
    @Column(name="REMOTE_NAME")
    @Size(max=50)
    private @Size(max=50) String jobName;
    @Size(max=50)
    @NotEmpty
    private @Size(max=50) @NotEmpty String label;
    @ManyToOne
    @JoinColumn(name="SERVER_ID")
    private TestAutomationServer server;
    @ManyToOne
    @JoinColumn(name="TM_PROJECT_ID")
    private GenericProject tmProject;
    @Column(name="EXECUTION_ENVIRONMENTS")
    private String slaves = "";
    @Column(name="CAN_RUN_GHERKIN")
    private boolean canRunGherkin = false;

    public TestAutomationProject() {
    }

    public TestAutomationProject(String jobName) {
        this(jobName, jobName);
    }

    public TestAutomationProject(String jobName, String label) {
        this.jobName = jobName;
        this.label = label;
    }

    public TestAutomationProject(String jobName, String label, TestAutomationServer server) {
        this(jobName, label);
        this.server = server;
    }

    public TestAutomationProject(String jobName, TestAutomationServer server) {
        this(jobName, jobName, server);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Deprecated
    public String getName() {
        return this.jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getLabel() {
        return this.label;
    }

    public TestAutomationServer getServer() {
        return this.server;
    }

    public void setServer(TestAutomationServer server) {
        this.server = server;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @AclConstrainedObject
    public GenericProject getTmProject() {
        return this.tmProject;
    }

    public void setTmProject(GenericProject tmProject) {
        this.tmProject = tmProject;
    }

    public String getSlaves() {
        return this.slaves;
    }

    public void setSlaves(String slaves) {
        this.slaves = slaves;
    }

    public boolean isCanRunGherkin() {
        return this.canRunGherkin;
    }

    public void setCanRunGherkin(boolean canRunGherkin) {
        this.canRunGherkin = canRunGherkin;
    }

    public boolean referencesSameJob(TestAutomationProject otherproject) {
        if (otherproject == null) {
            return false;
        }
        return otherproject.getJobName().equals(this.jobName) && otherproject.getServer().equals(this.server);
    }

    public TestAutomationProject createCopy() {
        TestAutomationProject copy = new TestAutomationProject(this.jobName, this.label, this.server);
        copy.setSlaves(this.slaves);
        copy.setTmProject(null);
        return copy;
    }
}

