/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;

@NamedQueries(value={@NamedQuery(name="automatedTest.countReferencesByTestCases", query="select count(*) from TestCase tc join tc.automatedTest autoTest where autoTest.id = :autoTestId"), @NamedQuery(name="automatedTest.countReferencesByExecutions", query="select count(*) from AutomatedExecutionExtender extender join extender.automatedTest autoTest where autoTest.id = :autoTestId"), @NamedQuery(name="automatedTest.findByTestCase", query="select auto from TestCase tc join tc.automatedTest auto where tc.id in (:testCaseIds)"), @NamedQuery(name="automatedTest.bulkDelete", query="delete from AutomatedTest auto where auto in (:tests)"), @NamedQuery(name="automatedTest.findOrphans", query="from AutomatedTest auto where not exists (from TestCase where automatedTest = auto) and not exists (from AutomatedExecutionExtender where automatedTest = auto)")})
@Entity
public class AutomatedTest
implements Identified {
    @Id
    @Column(name="TEST_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="automated_test_test_id_seq")
    @SequenceGenerator(name="automated_test_test_id_seq", sequenceName="automated_test_test_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private TestAutomationProject project;
    @Size(max=255)
    private @Size(max=255) String name;
    @Transient
    private List<String> linkedTC;

    protected AutomatedTest() {
    }

    public AutomatedTest(String name, TestAutomationProject project) {
        this.name = name;
        this.project = project;
    }

    public AutomatedTest(String name, TestAutomationProject project, List<String> linkedTC) {
        this.name = name;
        this.project = project;
        this.linkedTC = linkedTC;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public TestAutomationProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return "/" + this.project.getJobName() + "/" + this.name;
    }

    public String getFullLabel() {
        return "/" + this.project.getLabel() + "/" + this.name;
    }

    public String getPath() {
        return this.name.replaceAll("[^\\/]*$", "");
    }

    public String getShortName() {
        return this.name.replaceAll(".*\\/", "");
    }

    public String getNameWithoutRoot() {
        return this.name.replaceFirst("^[^\\/]*\\/", "");
    }

    public String getRootFolderName() {
        return this.name.replaceFirst("\\/.*$", "/");
    }

    public boolean isAtTheRoot() {
        return this.getPath().equals(this.getRootFolderName());
    }

    public AutomatedTest newWithProject(TestAutomationProject newP) {
        return new AutomatedTest(this.name, newP);
    }

    public List<String> getLinkedTC() {
        return this.linkedTC;
    }
}

