/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.testautomation;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotNull;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.SQLRestriction;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.RelatedToAuditable;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentTag;
import org.squashtest.tm.domain.environmentvariable.DenormalizedEnvironmentVariable;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionFlag;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
public class AutomatedExecutionExtender
implements Identified,
RelatedToAuditable {
    private static final Set<ExecutionStatus> AUTOMATED_EXEC_STATUS;
    @Id
    @Column(name="EXTENDER_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="automated_execution_extender_extender_id_seq")
    @SequenceGenerator(name="automated_execution_extender_extender_id_seq", sequenceName="automated_execution_extender_extender_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TEST_ID", referencedColumnName="TEST_ID")
    private AutomatedTest automatedTest;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="MASTER_EXECUTION_ID", referencedColumnName="EXECUTION_ID")
    private Execution execution;
    private URL resultURL;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SUITE_ID")
    private AutomatedSuite automatedSuite;
    @Lob
    @JdbcTypeCode(value=-1)
    private String resultSummary = "";
    @NotNull
    private String nodeName = "";
    private String testTechnology = "";
    @Column(name="DURATION")
    private Integer duration;
    @Column(name="FLAG")
    @Enumerated(value=EnumType.STRING)
    private ExecutionFlag flag;
    @OneToMany
    @JoinColumn(name="HOLDER_ID", referencedColumnName="EXTENDER_ID")
    @SQLRestriction(value="HOLDER_TYPE = 'AUTOMATED_EXECUTION_EXTENDER'")
    private List<DenormalizedEnvironmentVariable> denormalizedEnvironmentVariables = new ArrayList<DenormalizedEnvironmentVariable>();
    @OneToMany
    @JoinColumn(name="HOLDER_ID", referencedColumnName="EXTENDER_ID")
    @SQLRestriction(value="HOLDER_TYPE = 'AUTOMATED_EXECUTION_EXTENDER'")
    private List<DenormalizedEnvironmentTag> denormalizedEnvironmentTags = new ArrayList<DenormalizedEnvironmentTag>();
    @ManyToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY, mappedBy="automatedExecutions")
    private List<FailureDetail> failureDetailList = new ArrayList<FailureDetail>();

    static {
        HashSet<ExecutionStatus> set = new HashSet<ExecutionStatus>();
        set.add(ExecutionStatus.SUCCESS);
        set.add(ExecutionStatus.WARNING);
        set.add(ExecutionStatus.NOT_RUN);
        set.add(ExecutionStatus.NOT_FOUND);
        set.add(ExecutionStatus.ERROR);
        set.add(ExecutionStatus.FAILURE);
        set.add(ExecutionStatus.RUNNING);
        set.add(ExecutionStatus.READY);
        set.add(ExecutionStatus.SKIPPED);
        set.add(ExecutionStatus.CANCELLED);
        AUTOMATED_EXEC_STATUS = Collections.unmodifiableSet(set);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public Execution getExecution() {
        return this.execution;
    }

    @AclConstrainedObject
    public CampaignLibrary getCampaignLibrary() {
        return this.execution.getCampaignLibrary();
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public AutomatedTest getAutomatedTest() {
        return this.automatedTest;
    }

    public void setAutomatedTest(AutomatedTest automatedTest) {
        this.automatedTest = automatedTest;
    }

    public URL getResultURL() {
        return this.resultURL;
    }

    public void setResultURL(URL resultURL) {
        this.resultURL = resultURL;
    }

    public AutomatedSuite getAutomatedSuite() {
        return this.automatedSuite;
    }

    public void setAutomatedSuite(AutomatedSuite automatedSuite) {
        this.automatedSuite = automatedSuite;
    }

    public String getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(String resultSummary) {
        this.resultSummary = resultSummary;
    }

    public Set<ExecutionStatus> getLegalStatusSet() {
        return AUTOMATED_EXEC_STATUS;
    }

    public void setExecutionStatus(ExecutionStatus status) {
        this.execution.setExecutionStatus(status);
    }

    public TestAutomationProject getAutomatedProject() {
        return this.automatedTest.getProject();
    }

    public void setNodeName(String nodeName) {
        this.nodeName = StringUtils.trimToEmpty((String)nodeName);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isNotOverYet() {
        return this.automatedTest != null && this.resultURL == null;
    }

    public boolean isProjectDisassociated() {
        return this.automatedTest == null;
    }

    public List<DenormalizedEnvironmentVariable> getDenormalizedEnvironmentVariables() {
        return this.denormalizedEnvironmentVariables;
    }

    public void setDenormalizedEnvironmentVariables(List<DenormalizedEnvironmentVariable> denormalizedEnvironmentVariables) {
        this.denormalizedEnvironmentVariables = denormalizedEnvironmentVariables;
    }

    public List<DenormalizedEnvironmentTag> getDenormalizedEnvironmentTags() {
        return this.denormalizedEnvironmentTags;
    }

    public void setDenormalizedEnvironmentTags(List<DenormalizedEnvironmentTag> denormalizedEnvironmentTags) {
        this.denormalizedEnvironmentTags = denormalizedEnvironmentTags;
    }

    public void setTestTechnology(String testTechnology) {
        this.testTechnology = testTechnology;
    }

    public String getTestTechnology() {
        return this.testTechnology;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public ExecutionFlag getFlag() {
        return this.flag;
    }

    public void setFlag(ExecutionFlag flag) {
        this.flag = flag;
    }

    public List<FailureDetail> getFailureDetailList() {
        return this.failureDetailList;
    }

    @Override
    public List<AuditableMixin> getAssociatedAuditableList() {
        if (this.automatedSuite == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.automatedSuite);
    }

    public TestPlanItem getTestPlanItem() {
        return this.execution.getTestPlanItem();
    }
}

