/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.servers;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.SequenceGenerator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.URL;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;

@Entity
@Auditable
@Inheritance(strategy=InheritanceType.JOINED)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class ThirdPartyServer
extends BaseAuditableEntity {
    @Id
    @Column(name="SERVER_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="third_party_server_server_id_seq")
    @SequenceGenerator(name="third_party_server_server_id_seq", sequenceName="third_party_server_server_id_seq", allocationSize=1)
    private Long id;
    @NotBlank
    @Size(max=50)
    private @NotBlank @Size(max=50) String name;
    @NotBlank
    @URL
    @Size(max=255)
    private @NotBlank @URL @Size(max=255) String url;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="AUTH_POLICY")
    private AuthenticationPolicy authenticationPolicy = AuthenticationPolicy.USER;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="AUTH_PROTOCOL")
    private AuthenticationProtocol authenticationProtocol = AuthenticationProtocol.BASIC_AUTH;
    @Column(name="DESCRIPTION")
    private String description = "";

    protected ThirdPartyServer(String name, String url, String description) {
        this.name = name;
        this.url = url;
        this.description = description;
    }

    protected ThirdPartyServer() {
    }

    public Long getId() {
        return this.id;
    }

    private void doSetName(String name) {
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.doSetName(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StringUtils.trim((String)url);
    }

    public AuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    public void setAuthenticationPolicy(AuthenticationPolicy authenticationPolicy) {
        this.authenticationPolicy = authenticationPolicy;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void normalize() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            this.name = this.url;
        }
    }
}

