/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.servers;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import org.hibernate.annotations.JdbcTypeCode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.users.User;

@Entity
public class StoredCredentials {
    @Id
    @Column(name="CREDENTIAL_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="stored_credentials_credential_id_seq")
    @SequenceGenerator(name="stored_credentials_credential_id_seq", sequenceName="stored_credentials_credential_id_seq", allocationSize=1)
    private Long id;
    @Column(name="ENC_VERSION")
    private int encryptionVersion;
    @Lob
    @JdbcTypeCode(value=-1)
    @Column(name="ENC_CREDENTIALS")
    private String encryptedCredentials;
    @Column(name="CONTENT_TYPE")
    @Enumerated(value=EnumType.STRING)
    private ContentType contentType = ContentType.CRED;
    @ManyToOne
    @JoinColumn(name="AUTHENTICATED_SERVER")
    private ThirdPartyServer authenticatedServer;
    @ManyToOne
    @JoinColumn(name="AUTHENTICATED_USER")
    private User authenticatedUser;
    @ManyToOne
    @JoinColumn(name="PROJECT_ID")
    private GenericProject project;
    @Column(name="REPORTING_CACHE_CREDENTIALS")
    private boolean reportingCacheCredentials = false;

    public Long getId() {
        return this.id;
    }

    public int getEncryptionVersion() {
        return this.encryptionVersion;
    }

    public String getEncryptedCredentials() {
        return this.encryptedCredentials;
    }

    public void setEncryptionVersion(int encryptionVersion) {
        this.encryptionVersion = encryptionVersion;
    }

    public void setEncryptedCredentials(String encryptedCredentials) {
        this.encryptedCredentials = encryptedCredentials;
    }

    public ThirdPartyServer getAuthenticatedServer() {
        return this.authenticatedServer;
    }

    public void setAuthenticatedServer(ThirdPartyServer authenticatedServer) {
        this.authenticatedServer = authenticatedServer;
    }

    public User getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(User authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public GenericProject getProject() {
        return this.project;
    }

    public void setProject(GenericProject project) {
        this.project = project;
    }

    @Deprecated(since="4.0.0")
    public boolean isSystemCredentials() {
        return this.authenticatedUser == null && this.project == null;
    }

    public boolean isReportingCacheCredentials() {
        return this.reportingCacheCredentials;
    }

    public void setReportingCacheCredentials(boolean reportingCacheCredentials) {
        this.reportingCacheCredentials = reportingCacheCredentials;
    }

    public static enum ContentType {
        CRED,
        CONF;

    }
}

