/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.script;

import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.ast.Background;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import java.util.Collections;
import java.util.List;
import org.squashtest.tm.exception.testcase.ScriptParsingException;

public final class GherkinParser {
    private GherkinParser() {
        throw new IllegalStateException("Utility class");
    }

    public static GherkinDocument parseDocument(String script) {
        GherkinDocument gherkinDocument;
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        try {
            gherkinDocument = (GherkinDocument)parser.parse(script);
        }
        catch (ParserException ex) {
            throw new ScriptParsingException(ex.getMessage(), (Exception)((Object)ex));
        }
        return gherkinDocument;
    }

    public static List<String> extractBackgroundLines(String document) {
        return GherkinParser.extractBackgroundLines(GherkinParser.parseDocument(document));
    }

    public static List<String> extractBackgroundLines(GherkinDocument gherkinDocument) {
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return Collections.emptyList();
        }
        List scenarioDefinitions = feature.getChildren();
        if (scenarioDefinitions.isEmpty()) {
            return Collections.emptyList();
        }
        ScenarioDefinition potentialBackground = (ScenarioDefinition)scenarioDefinitions.get(0);
        if (potentialBackground instanceof Background) {
            Background background = (Background)potentialBackground;
            return background.getSteps().stream().map(Step::getText).toList();
        }
        return Collections.emptyList();
    }

    public static boolean hasScenarios(String document) {
        return GherkinParser.hasScenarios(GherkinParser.parseDocument(document));
    }

    public static boolean hasScenarios(GherkinDocument document) {
        return document != null && document.getFeature() != null && !document.getFeature().getChildren().isEmpty() && document.getFeature().getChildren().stream().anyMatch(definition -> !(definition instanceof Background));
    }
}

