/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.scm;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.servers.ThirdPartyServer;

@Entity
@Table(name="SCM_SERVER")
@PrimaryKeyJoinColumn(name="SERVER_ID")
public class ScmServer
extends ThirdPartyServer {
    @Column(name="KIND")
    @Size(max=30)
    private @Size(max=30) String kind;
    @Column(name="COMMITTER_MAIL")
    @Size(max=255)
    @Email
    private @Size(max=255) @Email String committerMail = "";
    @Column(name="CREDENTIALS_NOT_SHARED")
    boolean credentialsNotShared = false;
    @OneToMany(mappedBy="scmServer", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ScmRepository> repositories = new ArrayList<ScmRepository>();

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getCommitterMail() {
        return this.committerMail;
    }

    public void setCommitterMail(String committerMail) {
        this.committerMail = committerMail;
    }

    public boolean isCredentialsNotShared() {
        return this.credentialsNotShared;
    }

    public void setCredentialsNotShared(boolean credentialsNotShared) {
        this.credentialsNotShared = credentialsNotShared;
    }

    public List<ScmRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<ScmRepository> repositories) {
        this.repositories = repositories;
    }

    public String getFriendlyName() {
        return String.format("%s (%s)", this.getName(), this.getUrl());
    }
}

