/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.scm;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.scm.ScmServer;

@Entity
@Table(name="SCM_REPOSITORY")
public class ScmRepository {
    private static final String SLASH = "/";
    private static final String FRIENDLY_DISPLAY_FORMAT = "%s (%s)";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmRepository.class);
    private static final Map<Long, Object> repositoriesLocks = new ConcurrentHashMap<Long, Object>();
    @Id
    @Column(name="SCM_REPOSITORY_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="scm_repository_scm_repository_id_seq")
    @SequenceGenerator(name="scm_repository_scm_repository_id_seq", sequenceName="scm_repository_scm_repository_id_seq", allocationSize=1)
    private Long id;
    @Column(name="NAME")
    @NotBlank
    @Size(max=255)
    private @NotBlank @Size(max=255) String name;
    @Column(name="REPOSITORY_PATH")
    private String repositoryPath;
    @Column(name="WORKING_FOLDER_PATH")
    private String workingFolderPath;
    @Column(name="WORKING_BRANCH")
    @NotBlank
    private String workingBranch;
    @ManyToOne
    @JoinColumn(name="SERVER_ID", nullable=false)
    private ScmServer scmServer;

    private Object acquireLock() {
        return repositoriesLocks.computeIfAbsent(this.id, repositoryId -> new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doWithLock(IOSupplier<T> operation) throws IOException {
        T result;
        Object lock;
        LOGGER.trace("attempting to acquire lock on repository '{}'", new Object[]{this.name});
        Object object = lock = this.acquireLock();
        synchronized (object) {
            LOGGER.trace("lock acquired on repository '{}'", new Object[]{this.name});
            result = operation.get();
        }
        LOGGER.trace("lock released on repository '{}'", new Object[]{this.name});
        return result;
    }

    public File getBaseRepositoryFolder() {
        return new File(this.getRepositoryPath());
    }

    public File getWorkingFolder() {
        if (StringUtils.isBlank((CharSequence)this.workingFolderPath)) {
            return this.getBaseRepositoryFolder();
        }
        return FileUtils.getFile((String[])new String[]{this.repositoryPath, this.workingFolderPath});
    }

    public Collection<File> listWorkingFolderContent() throws IOException {
        File workingFolder = this.getWorkingFolder();
        return this.doWithLock(() -> FileUtils.listFiles((File)workingFolder, null, (boolean)true));
    }

    public String getFullUrl() {
        StringBuilder builder = new StringBuilder();
        String scmServerUrl = this.scmServer.getUrl();
        builder.append(scmServerUrl);
        if (!scmServerUrl.endsWith(SLASH)) {
            builder.append(SLASH);
        }
        builder.append(this.name);
        return builder.toString();
    }

    public String getFriendlyUrl() {
        return String.format(FRIENDLY_DISPLAY_FORMAT, this.getFullUrl(), this.getWorkingBranch());
    }

    public String getFriendlyName() {
        return String.format(FRIENDLY_DISPLAY_FORMAT, this.getName(), this.getWorkingBranch());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorkingBranch() {
        return this.workingBranch;
    }

    public void setWorkingBranch(String workingBranch) {
        this.workingBranch = workingBranch;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getWorkingFolderPath() {
        return this.workingFolderPath;
    }

    public void setWorkingFolderPath(String workingFolderPath) {
        this.workingFolderPath = workingFolderPath;
    }

    public ScmServer getScmServer() {
        return this.scmServer;
    }

    public void setScmServer(ScmServer scmServer) {
        this.scmServer = scmServer;
    }

    @FunctionalInterface
    public static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

