/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Table;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.audit.Auditable;
import org.squashtest.tm.domain.audit.BaseAuditableEntity;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(appliesTo="RLN_RESOURCE", sqlDelete=@SQLDelete(sql="delete from REQUIREMENT where RLN_ID=null and RLN_ID=?"))
@Auditable
public abstract class RequirementLibraryNode<RESOURCE extends Resource>
extends BaseAuditableEntity
implements LibraryNode {
    @Id
    @Column(name="RLN_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="requirement_library_node_rln_id_seq")
    @SequenceGenerator(name="requirement_library_node_rln_id_seq", sequenceName="requirement_library_node_rln_id_seq", allocationSize=30)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinTable(name="RLN_RESOURCE", joinColumns={@JoinColumn(name="RLN_ID", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="RES_ID")})
    @Immutable
    private Resource mainResource;

    public RequirementLibraryNode() {
    }

    public RequirementLibraryNode(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public Resource getMainResource() {
        return this.mainResource;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void notifyAssociatedWithProject(Project project) {
        this.project = project;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    @AclConstrainedObject
    public Library<?> getLibrary() {
        return this.getProject().getRequirementLibrary();
    }

    @Override
    public AttachmentList getAttachmentList() {
        return ((Resource)this.getResource()).getAttachmentList();
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return this.getProject().getId();
    }

    public abstract void accept(RequirementLibraryNodeVisitor var1);

    public abstract RESOURCE getResource();
}

