/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import jakarta.persistence.Entity;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.requirement.ForbiddenHighLevelLinkException;

@Entity
@PrimaryKeyJoinColumn(name="RLN_ID")
public class HighLevelRequirement
extends Requirement {
    protected HighLevelRequirement() {
    }

    public HighLevelRequirement(@NotNull RequirementVersion version) {
        super(version);
    }

    @Override
    public boolean isHighLevel() {
        return true;
    }

    @Override
    public void setHighLevelRequirement(HighLevelRequirement highLevelRequirement) {
        throw new ForbiddenHighLevelLinkException();
    }

    @Override
    protected void assignHighLevelRequirement(@NotNull Requirement content) {
        Requirement requirement = content;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirement);
        content.cascadeHighLevelRequirementAssignment(this);
    }

    @Override
    protected void cascadeHighLevelRequirementAssignment(HighLevelRequirement highLevelRequirement) {
        throw new ForbiddenHighLevelLinkException();
    }

    @Override
    public HighLevelRequirement createCopy() {
        HighLevelRequirement copy = new HighLevelRequirement();
        copy.notifyAssociatedWithProject((Project)this.getProject());
        RequirementVersion latestVersionCopy = this.getCurrentVersion().createPastableCopy(copy);
        copy.addVersion(latestVersionCopy);
        copy.resource = latestVersionCopy;
        return copy;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addContent(Requirement child) throws DuplicateNameException, NullArgumentException {
        Requirement requirement = child;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)requirement);
        super.addContent(child, this.getContent().size());
    }
}

