/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.requirement;

import org.squashtest.tm.domain.library.AbstractExportData;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;

public class ExportRequirementData
extends AbstractExportData {
    public static final Long NO_REQUIREMENT_PARENT_ID = -1L;
    public static final String NO_REQUIREMENT_PARENT_PATH = "";
    private RequirementCriticality criticality;
    private String category;
    private Integer currentVersion;
    private RequirementStatus status;
    private String reference = "";
    private String milestone = "";
    private String requirementParentPath = "";
    private Long requirementParentId;

    public ExportRequirementData(Requirement requirement, String requirementFolderPath, String requirementParentPath) {
        super(requirement);
        this.doSetReference(requirement.getReference());
        this.criticality = requirement.getCriticality();
        int index = 0;
        for (Milestone m : requirement.getCurrentVersion().getMilestones()) {
            if (index > 0) {
                this.milestone = String.valueOf(this.milestone) + " | ";
            }
            this.milestone = String.valueOf(this.milestone) + m.getLabel();
            ++index;
        }
        this.category = requirement.getCategory().getCode();
        this.currentVersion = requirement.getCurrentVersion().getVersionNumber();
        this.status = requirement.getStatus();
        this.setFolderName(requirementFolderPath);
        this.doSetRequirementParentPath(requirementParentPath);
    }

    public ExportRequirementData() {
    }

    public String getMilestone() {
        return this.milestone;
    }

    public void setMilestone(String milestone) {
        this.milestone = milestone;
    }

    public RequirementCriticality getCriticality() {
        return this.criticality;
    }

    public void setCriticality(RequirementCriticality criticality) {
        this.criticality = criticality;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
    }

    public RequirementStatus getStatus() {
        return this.status;
    }

    public void setStatus(RequirementStatus status) {
        this.status = status;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.doSetReference(reference);
    }

    private void doSetReference(String reference) {
        if (reference != null) {
            this.reference = reference;
        }
    }

    public String getRequirementParentPath() {
        return this.requirementParentPath;
    }

    public void setRequirementParentId(Long requirementParentId) {
        this.requirementParentId = requirementParentId;
    }

    public void setRequirementParentPath(String requirementParentPath) {
        this.doSetRequirementParentPath(requirementParentPath);
    }

    private void doSetRequirementParentPath(String requirementParentPath) {
        this.requirementParentPath = requirementParentPath;
    }

    public Long getRequirementParentId() {
        return this.requirementParentId;
    }
}

