/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import org.squashtest.tm.domain.EntityType;

@Embeddable
public class SpecializedEntityType {
    @Enumerated(value=EnumType.STRING)
    private EntityType entityType;
    @Enumerated(value=EnumType.STRING)
    private EntityRole entityRole;

    protected SpecializedEntityType() {
    }

    public SpecializedEntityType(EntityType entityType, EntityRole entityRole) {
        this.entityType = entityType;
        this.entityRole = entityRole;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public EntityRole getEntityRole() {
        return this.entityRole;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entityRole == null ? 0 : this.entityRole.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecializedEntityType other = (SpecializedEntityType)obj;
        if (this.entityRole != other.entityRole) {
            return false;
        }
        return this.entityType == other.entityType;
    }

    public static enum EntityRole {
        TEST_CASE_NATURE,
        TEST_CASE_TYPE,
        REQUIREMENT_VERSION_CATEGORY,
        ITERATION_TEST_PLAN_ASSIGNED_USER,
        TEST_CASE_MILESTONE,
        REQUIREMENT_VERSION_MILESTONE,
        CUSTOM_FIELD,
        CAMPAIGN_MILESTONE,
        TEST_CASE_PROJECT,
        REQUIREMENT_PROJECT,
        CAMPAIGN_PROJECT,
        TEST_CASE_ATTLIST,
        REQUIREMENT_VERSION_ATTLIST,
        CAMPAIGN_ATTLIST,
        ITEM_SUITE,
        TEST_CASE_ATTACHMENT,
        REQUIREMENT_VERSION_ATTACHMENT,
        CAMPAIGN_ATTACHMENT;

    }
}

