/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.query;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.squashtest.tm.domain.query.Operation;

public enum DataType {
    NUMERIC(Operation.AVG, Operation.BETWEEN, Operation.COUNT, Operation.EQUALS, Operation.GREATER, Operation.GREATER_EQUAL, Operation.LOWER, Operation.LOWER_EQUAL, Operation.MAX, Operation.MIN, Operation.SUM, Operation.NONE, Operation.NOT_EQUALS),
    STRING(Operation.EQUALS, Operation.LIKE, Operation.COUNT, Operation.NONE),
    DATE(Operation.BETWEEN, Operation.COUNT, Operation.EQUALS, Operation.GREATER, Operation.GREATER_EQUAL, Operation.LOWER, Operation.LOWER_EQUAL, Operation.BY_DAY, Operation.BY_WEEK, Operation.BY_MONTH, Operation.BY_YEAR, Operation.NOT_EQUALS),
    DATE_AS_STRING(Operation.BETWEEN, Operation.COUNT, Operation.EQUALS, Operation.GREATER, Operation.GREATER_EQUAL, Operation.LOWER, Operation.LOWER_EQUAL, Operation.BY_DAY, Operation.BY_MONTH, Operation.BY_YEAR, Operation.NOT_EQUALS),
    EXISTENCE(Operation.NOT_NULL, Operation.IS_NULL),
    BOOLEAN(Operation.EQUALS, Operation.COUNT, Operation.NONE),
    BOOLEAN_AS_STRING(Operation.EQUALS, Operation.COUNT, Operation.NONE),
    LEVEL_ENUM(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    REQUIREMENT_STATUS(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    AUTOMATED_TEST_TECHNOLOGY(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    EXECUTION_STATUS(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    LIST(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    INFO_LIST_ITEM(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    TAG(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    ENUM(Operation.EQUALS, Operation.IN, Operation.COUNT, Operation.NONE),
    ENTITY(Operation.IS_CLASS),
    TEXT(Operation.LIKE, Operation.FULLTEXT, Operation.NONE);

    private EnumSet<Operation> operations;

    private DataType(Operation ... operations) {
        this.operations = EnumSet.copyOf(Arrays.asList(operations));
    }

    public Set<Operation> getOperations() {
        return EnumSet.copyOf(this.operations);
    }

    public boolean isAssignableToLevelEnum() {
        return switch (this) {
            case LEVEL_ENUM, REQUIREMENT_STATUS, EXECUTION_STATUS -> true;
            default -> false;
        };
    }
}

