/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.projectimporter;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportType;
import org.squashtest.tm.domain.users.User;

@Entity
@Table(name="PIVOT_FORMAT_IMPORT")
public class PivotFormatImport {
    @Id
    @Column(name="PFI_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pivot_format_import_pfi_id_seq")
    @SequenceGenerator(name="pivot_format_import_pfi_id_seq", sequenceName="pivot_format_import_pfi_id_seq", allocationSize=1)
    private long id;
    @Column(name="NAME")
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CREATED_BY")
    private User createdBy;
    @Column(updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdOn;
    @Column(name="FILE_PATH")
    private String filePath;
    @Column(name="STATUS")
    @Enumerated(value=EnumType.STRING)
    private PivotFormatImportStatus status = PivotFormatImportStatus.PENDING;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID")
    private Project project;
    @Column(name="IMPORT_TYPE")
    @Enumerated(value=EnumType.STRING)
    private PivotFormatImportType type;
    @Column(name="SUCCESSFULLY_IMPORTED_ON")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date successfullyImportedOn;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public PivotFormatImportStatus getStatus() {
        return this.status;
    }

    public void setStatus(PivotFormatImportStatus status) {
        this.status = status;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Date getSuccessfullyImportedOn() {
        return this.successfullyImportedOn;
    }

    public void setSuccessfullyImportedOn(Date successfullyImportedOn) {
        this.successfullyImportedOn = successfullyImportedOn;
    }

    public PivotFormatImportType getType() {
        return this.type;
    }

    public void setType(PivotFormatImportType source) {
        this.type = source;
    }
}

