/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.project;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;

@Entity
@Table(name="TEMPLATE_CONFIGURABLE_PLUGIN_BINDING")
public class TemplateConfigurablePluginBinding {
    @Id
    @Column(name="BINDING_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="template_configurable_plugin_binding_binding_id_seq")
    @SequenceGenerator(name="template_configurable_plugin_binding_binding_id_seq", sequenceName="template_configurable_plugin_binding_binding_id_seq", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_TEMPLATE_ID", referencedColumnName="PROJECT_ID")
    private ProjectTemplate projectTemplate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PROJECT_ID", referencedColumnName="PROJECT_ID")
    private Project project;
    @Column
    private String pluginId;

    public TemplateConfigurablePluginBinding() {
    }

    private TemplateConfigurablePluginBinding(ProjectTemplate template, Project project, String pluginId) {
        this();
        this.projectTemplate = template;
        this.project = project;
        this.pluginId = pluginId;
    }

    public Long getId() {
        return this.id;
    }

    void setId(Long id) {
        this.id = id;
    }

    public ProjectTemplate getProjectTemplate() {
        return this.projectTemplate;
    }

    public Project getProject() {
        return this.project;
    }

    void setProject(Project attachedProject) {
        this.project = attachedProject;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public static TemplateConfigurablePluginBinding createBinding(ProjectTemplate template, Project project, TemplateConfigurablePlugin plugin) {
        if (template == null || project == null || plugin == null) {
            throw new IllegalArgumentException();
        }
        return new TemplateConfigurablePluginBinding(template, project, plugin.getId());
    }
}

