/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.project;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.api.plugin.PluginType;

@Entity
@DiscriminatorColumn(name="LIBRARY_TYPE", discriminatorType=DiscriminatorType.STRING)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="LIBRARY_PLUGIN_BINDING")
public abstract class LibraryPluginBinding {
    @Id
    @Column(name="PLUGIN_BINDING_ID")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="library_plugin_binding_plugin_binding_id_seq")
    @SequenceGenerator(name="library_plugin_binding_plugin_binding_id_seq", sequenceName="library_plugin_binding_plugin_binding_id_seq", allocationSize=1)
    private long id;
    @Column
    private String pluginId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="PLUGIN_TYPE")
    private PluginType pluginType;
    @Column(name="ACTIVE")
    private Boolean active = true;
    @ElementCollection
    @CollectionTable(name="LIBRARY_PLUGIN_BINDING_PROPERTY", joinColumns={@JoinColumn(name="PLUGIN_BINDING_ID")})
    @MapKeyColumn(name="PLUGIN_BINDING_KEY")
    @Column(name="PLUGIN_BINDING_VALUE")
    private Map<String, String> properties = new HashMap<String, String>(2);

    protected LibraryPluginBinding() {
    }

    protected LibraryPluginBinding(String pluginId) {
        this.pluginId = pluginId;
    }

    protected LibraryPluginBinding(String pluginId, PluginType pluginType) {
        this.pluginId = pluginId;
        this.pluginType = pluginType;
    }

    public long getId() {
        return this.id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Set<String> listProperties() {
        return this.properties.keySet();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }
}

