/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.project;

import jakarta.persistence.CascadeType;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToOne;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.LibraryNodeUtils;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectUtils;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.security.annotation.AclConstrainedObject;

@MappedSuperclass
public abstract class GenericLibrary<NODE extends LibraryNode>
implements Library<NODE> {
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ATTACHMENT_LIST_ID")
    private final AttachmentList attachmentList = new AttachmentList();

    @Override
    public boolean isContentNameAvailable(String name) {
        if (this.allowContentWithIdenticalName()) {
            return true;
        }
        for (LibraryNode content : this.getContent()) {
            if (!content.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addContent(@NotNull NODE node) throws UnsupportedOperationException {
        NODE NODE = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(NODE);
        if (!node.allowIdenticalName()) {
            this.checkContentNameAvailable(node);
        }
        this.getContent().add(node);
        ((GenericProject)this.getProject()).accept(new ProjectVisitor((LibraryNode)node){
            private final /* synthetic */ LibraryNode val$node;
            {
                this.val$node = libraryNode;
            }

            @Override
            public void visit(Project project) {
                this.val$node.notifyAssociatedWithProject(project);
            }

            @Override
            public void visit(ProjectTemplate projectTemplate) {
                throw new UnsupportedOperationException(LibraryNodeUtils.toString(this.val$node) + " cannot be added to " + ProjectUtils.toString(projectTemplate));
            }
        });
    }

    @Override
    public void addContent(@NotNull NODE node, int position) throws UnsupportedOperationException {
        NODE NODE = node;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(NODE);
        this.checkContentNameAvailable(node);
        if (position >= this.getContent().size() || position < 0) {
            this.getContent().add(node);
        } else {
            this.getContent().add(position, node);
        }
        ((GenericProject)this.getProject()).accept(new ProjectVisitor((LibraryNode)node){
            private final /* synthetic */ LibraryNode val$node;
            {
                this.val$node = libraryNode;
            }

            @Override
            public void visit(Project project) {
                this.val$node.notifyAssociatedWithProject(project);
            }

            @Override
            public void visit(ProjectTemplate projectTemplate) {
                throw new UnsupportedOperationException(LibraryNodeUtils.toString(this.val$node) + " cannot be added to " + ProjectUtils.toString(projectTemplate));
            }
        });
        List orig = this.getContent();
        ArrayList reindexed = new ArrayList(orig);
        orig.clear();
        orig.addAll(reindexed);
    }

    private void checkContentNameAvailable(NODE candidateContent) throws DuplicateNameException {
        if (!this.isContentNameAvailable(candidateContent.getName())) {
            throw new DuplicateNameException(candidateContent.getName(), candidateContent.getName());
        }
    }

    @Override
    @AclConstrainedObject
    public Library<?> getLibrary() {
        return this;
    }

    @Override
    public List<String> getContentNames() {
        ArrayList<String> contentNames = new ArrayList<String>(this.getContent().size());
        for (LibraryNode node : this.getContent()) {
            contentNames.add(node.getName());
        }
        return contentNames;
    }

    @Override
    public AttachmentList getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public Long getAttachmentHolderProjectId() {
        return ((GenericProject)this.getProject()).getId();
    }
}

