/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library.structures;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.library.structures.LibraryTree;

public abstract class TreeNode<IDENT, T extends TreeNode<IDENT, T>> {
    private final List<T> children = new ArrayList<T>();
    private T parent;
    private LibraryTree<IDENT, T> tree;
    private int depth;
    private IDENT key;

    protected TreeNode() {
    }

    protected TreeNode(IDENT key) {
        this.key = key;
    }

    protected abstract T self();

    public List<T> getChildren() {
        return this.children;
    }

    LibraryTree<IDENT, T> getTree() {
        return this.tree;
    }

    void setTree(LibraryTree<IDENT, T> tree) {
        this.tree = tree;
    }

    public T getParent() {
        return this.parent;
    }

    public IDENT getKey() {
        return this.key;
    }

    public void setKey(IDENT key) {
        this.key = key;
    }

    int getDepth() {
        return this.depth;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    List<T> getHierarchy() {
        ArrayList<T> result = new ArrayList<T>();
        T nodeIterator = this.self();
        while (nodeIterator != null) {
            result.add(nodeIterator);
            nodeIterator = ((TreeNode)nodeIterator).getParent();
        }
        return result;
    }

    void recomputeDepth() {
        this.depth = this.getHierarchy().size() - 1;
    }

    void setParent(T parent) {
        this.parent = parent;
    }

    void addChild(T child) {
        ((TreeNode)child).setParent(this.self());
        ((TreeNode)child).setTree(this.tree);
        ((TreeNode)child).setDepth(this.depth + 1);
        this.children.add(child);
    }

    protected abstract void updateWith(T var1);
}

