/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library.structures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.squashtest.tm.domain.library.structures.TreeNode;

public class LibraryTree<IDENT, T extends TreeNode<IDENT, T>> {
    protected final Map<Integer, List<T>> layers = new HashMap<Integer, List<T>>();

    public List<T> getLayer(Integer depth) {
        if (depth < 0) {
            throw new IndexOutOfBoundsException("Below lower bound : " + String.valueOf(depth));
        }
        if (depth > Collections.max(this.layers.keySet())) {
            throw new IndexOutOfBoundsException("Above upper bound : " + String.valueOf(depth));
        }
        return this.layers.get(depth);
    }

    public void addNode(TreeNodePair newPair) {
        Object parent = this.getNode(newPair.getParentKey());
        Object childNode = newPair.getChild();
        if (parent == null) {
            if (this.layers.get(0) == null) {
                this.layers.put(0, new ArrayList());
            }
            ((TreeNode)childNode).setParent(null);
            ((TreeNode)childNode).setTree(this);
            ((TreeNode)childNode).setDepth(0);
            this.layers.get(0).add(childNode);
        } else {
            ((TreeNode)parent).addChild(childNode);
            int layerIndex = ((TreeNode)childNode).getDepth();
            if (this.layers.get(layerIndex) == null) {
                this.layers.put(layerIndex, new ArrayList());
            }
            this.layers.get(layerIndex).add(childNode);
        }
    }

    public void addNode(IDENT parentKey, T childNode) {
        this.addNode(new TreeNodePair(this, parentKey, childNode));
    }

    public void addNodes(List<TreeNodePair> unsortedFlatTree) {
        List<TreeNodePair> cleanPairs = this.cleanData(unsortedFlatTree);
        HashMap newNodesByKey = new HashMap();
        HashSet rootNodes = new HashSet();
        for (TreeNodePair pair : cleanPairs) {
            newNodesByKey.put(((TreeNode)pair.child).getKey(), pair.child);
            if (pair.parentKey == null) {
                rootNodes.add(pair.child);
            }
            ((TreeNode)pair.child).setTree(this);
        }
        for (TreeNodePair pair : cleanPairs) {
            if (rootNodes.contains(pair.child)) continue;
            TreeNode parent = (TreeNode)newNodesByKey.get(pair.parentKey);
            TreeNode child = (TreeNode)newNodesByKey.get(((TreeNode)pair.child).getKey());
            parent.addChild(child);
        }
        this.integrateNodes(0, rootNodes);
    }

    private void integrateNodes(int layerindex, Collection<T> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        List<T> layer = this.getLayer(layerindex);
        ArrayList nextLayer = new ArrayList();
        for (TreeNode node : nodes) {
            node.setDepth(layerindex);
            layer.add(node);
            nextLayer.addAll(node.getChildren());
        }
        this.integrateNodes(layerindex + 1, nextLayer);
    }

    private List<T> getLayer(int index) {
        if (this.layers.get(index) == null) {
            this.layers.put(index, new ArrayList());
        }
        return this.layers.get(index);
    }

    private List<TreeNodePair> cleanData(List<TreeNodePair> corruptData) {
        HashMap pairByChildKey = new HashMap();
        for (TreeNodePair pair : corruptData) {
            Object childKey = ((TreeNode)pair.getChild()).getKey();
            TreeNodePair foundPair = (TreeNodePair)pairByChildKey.get(childKey);
            if (foundPair == null) {
                pairByChildKey.put(childKey, pair);
                continue;
            }
            if (pair.getParentKey() == null) continue;
            pairByChildKey.put(childKey, pair);
        }
        return new ArrayList<TreeNodePair>(pairByChildKey.values());
    }

    public T getNode(IDENT key) {
        if (key == null) {
            return null;
        }
        for (TreeNode node : this.getAllNodes()) {
            if (!node.getKey().equals(key)) continue;
            return (T)node;
        }
        throw new NoSuchElementException("No element tagged as " + key.toString() + " found in this tree");
    }

    public void doBottomUp(Closure closure) {
        if (!this.layers.isEmpty()) {
            Integer layerIndex = Collections.max(this.layers.keySet());
            while (layerIndex >= 0) {
                ArrayList layer = new ArrayList(this.layers.get(layerIndex));
                CollectionUtils.forAllDo(layer, (Closure)closure);
                layerIndex = layerIndex - 1;
            }
        }
    }

    public void doTopDown(Closure closure) {
        Integer layerIndex = 0;
        while (layerIndex <= Collections.max(this.layers.keySet())) {
            List<T> layer = this.layers.get(layerIndex);
            CollectionUtils.forAllDo(layer, (Closure)closure);
            layerIndex = layerIndex + 1;
        }
    }

    public void merge(List<T> mergeData) {
        for (TreeNode data : mergeData) {
            TreeNode node = this.getNode(data.getKey());
            node.updateWith((TreeNode)data);
        }
    }

    public <X> List<X> collect(Transformer transformer) {
        return new ArrayList(CollectionUtils.collect(this.getAllNodes(), (Transformer)transformer));
    }

    public List<IDENT> collectKeys() {
        return this.getAllNodes().stream().map(TreeNode::getKey).collect(Collectors.toList());
    }

    public List<T> getAllNodes() {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> layer : this.layers.values()) {
            result.addAll(layer);
        }
        return result;
    }

    public List<T> getRootNodes() {
        if (this.layers.isEmpty()) {
            throw new IndexOutOfBoundsException("This tree has no root");
        }
        return new ArrayList(this.layers.get(0));
    }

    public List<T> getLeaves() {
        return this.getAllNodes().stream().filter(node -> node.getChildren().isEmpty()).toList();
    }

    public boolean mayRemove(IDENT key) {
        T node = this.getNode(key);
        return ((TreeNode)node).getChildren().isEmpty();
    }

    public void remove(IDENT key) {
        T node = this.getNode(key);
        if (((TreeNode)node).getChildren().isEmpty()) {
            Collection layer = this.layers.get(((TreeNode)node).getDepth());
            layer.remove(node);
            Object parent = ((TreeNode)node).getParent();
            if (parent != null) {
                ((TreeNode)parent).getChildren().remove(node);
            }
        } else {
            throw new IllegalArgumentException("Cannot remove node '" + String.valueOf(key) + "' : it has no children");
        }
    }

    public void cut(IDENT key) {
        T node = this.getNode(key);
        Object parent = ((TreeNode)node).getParent();
        if (parent != null) {
            ((TreeNode)parent).getChildren().remove(node);
        }
        LinkedList processing = new LinkedList();
        processing.add(node);
        while (!processing.isEmpty()) {
            TreeNode current = (TreeNode)processing.pop();
            List<T> layer = this.layers.get(current.getDepth());
            layer.remove(current);
            processing.addAll(current.getChildren());
        }
    }

    public int getDepth() {
        return Collections.max(this.layers.keySet()) + 1;
    }

    protected T createNewNode(T parent, int depth, T newNode) {
        ((TreeNode)newNode).setParent(parent);
        ((TreeNode)newNode).setDepth(depth);
        ((TreeNode)newNode).setTree(this);
        return newNode;
    }

    public TreeNodePair newPair() {
        return new TreeNodePair();
    }

    public TreeNodePair newPair(IDENT parentKey, T child) {
        return new TreeNodePair(this, parentKey, child);
    }

    public static final class SimpleNode<T>
    extends TreeNode<T, SimpleNode<T>> {
        public SimpleNode() {
        }

        public SimpleNode(T key) {
            super(key);
        }

        @Override
        protected void updateWith(SimpleNode<T> newData) {
        }

        @Override
        protected SimpleNode<T> self() {
            return this;
        }
    }

    public class TreeNodePair {
        private IDENT parentKey;
        private T child;

        public TreeNodePair() {
        }

        public TreeNodePair(IDENT parentKey, T child) {
            this.parentKey = parentKey;
            this.child = child;
        }

        public String toString() {
            return "[" + String.valueOf(this.parentKey) + " : " + String.valueOf(((TreeNode)this.child).getKey()) + "]";
        }

        public IDENT getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(IDENT parentKey) {
            this.parentKey = parentKey;
        }

        public T getChild() {
            return this.child;
        }

        public void setChild(T child) {
            this.child = child;
        }
    }
}

