/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library.structures;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class GraphNode<IDENT, T extends GraphNode<IDENT, T>> {
    protected IDENT key;
    protected final Collection<T> inbounds = new LinkedList<T>();
    protected final Collection<T> outbounds = new LinkedList<T>();

    public GraphNode() {
    }

    public GraphNode(IDENT key) {
        this.key = key;
    }

    public Collection<T> getInbounds() {
        return this.inbounds;
    }

    public Collection<T> getOutbounds() {
        return this.outbounds;
    }

    public void addInbound(T inbound) {
        if (inbound != null) {
            this.inbounds.add(inbound);
        }
    }

    public void addOutbound(T outbound) {
        if (outbound != null) {
            this.outbounds.add(outbound);
        }
    }

    public void removeInbound(T inbound) {
        this.inbounds.remove(inbound);
    }

    public void removeOutbount(T outbound) {
        this.outbounds.remove(outbound);
    }

    public IDENT getKey() {
        return this.key;
    }

    public void setKey(IDENT key) {
        this.key = key;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public void disconnect(T node) {
        Iterator<T> iter = ((GraphNode)node).inbounds.iterator();
        while (iter.hasNext()) {
            if (!((GraphNode)iter.next()).equals(this)) continue;
            iter.remove();
        }
        iter = this.outbounds.iterator();
        while (iter.hasNext()) {
            if (!((GraphNode)iter.next()).equals(node)) continue;
            iter.remove();
        }
    }
}

