/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.domain.library;

import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.SprintGroupContainer;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.DuplicateNameException;

public class SprintGroupSupport<NODE extends LibraryNode, SPRINT_GROUP extends SprintGroupContainer<NODE>> {
    private final SPRINT_GROUP sprintGroup;

    public SprintGroupSupport(SPRINT_GROUP sprintGroupContainer) {
        this.sprintGroup = sprintGroupContainer;
    }

    public void addContent(NODE node) {
        if (!node.allowIdenticalName()) {
            this.checkContentNameAvailable(node);
        }
        this.sprintGroup.getContent().add(node);
        node.notifyAssociatedWithProject(this.sprintGroup.getProject());
    }

    public void addContent(NODE node, int position) {
        if (!node.allowIdenticalName()) {
            this.checkContentNameAvailable(node);
        }
        if (position >= this.sprintGroup.getContent().size() || position < 0) {
            this.sprintGroup.addContent(node);
        } else {
            this.sprintGroup.getContent().add(position, node);
        }
        node.notifyAssociatedWithProject(this.sprintGroup.getProject());
    }

    private void checkContentNameAvailable(NODE candidateContent) throws DuplicateNameException {
        if (!this.sprintGroup.allowContentWithIdenticalName() && !this.isContentNameAvailable(candidateContent.getName())) {
            throw new DuplicateNameException(candidateContent.getName(), candidateContent.getName());
        }
    }

    public boolean isContentNameAvailable(String name) {
        for (LibraryNode folderContent : this.sprintGroup.getContent()) {
            if (!folderContent.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void notifyAssociatedProjectWasSet(Project formerProject, Project currentProject) {
        if (this.notSameProject(formerProject, currentProject)) {
            for (LibraryNode node : this.sprintGroup.getContent()) {
                node.notifyAssociatedWithProject(currentProject);
            }
        }
    }

    private boolean notSameProject(Project thisProject, Project thatProject) {
        if (thisProject == null && thatProject == null) {
            return false;
        }
        if (thisProject == null) {
            return true;
        }
        return !thisProject.equals(thatProject);
    }

    public boolean hasContent() {
        return !this.sprintGroup.getContent().isEmpty();
    }

    public SPRINT_GROUP createCopy(SPRINT_GROUP newFolder) {
        newFolder.setName(this.sprintGroup.getName());
        newFolder.setDescription(this.sprintGroup.getDescription());
        newFolder.notifyAssociatedWithProject(this.sprintGroup.getProject());
        this.addCopiesOfAttachments((SprintGroupContainer<NODE>)this.sprintGroup, (SprintGroupContainer<NODE>)newFolder);
        return newFolder;
    }

    private void addCopiesOfAttachments(SprintGroupContainer<NODE> source, SprintGroupContainer<NODE> destination) {
        for (Attachment tcAttach : source.getAttachmentList().getAllAttachments()) {
            Attachment atCopy = tcAttach.shallowCopy();
            destination.getAttachmentList().addAttachment(atCopy);
        }
    }

    public List<String> getContentNames() {
        ArrayList<String> contentNames = new ArrayList<String>(this.sprintGroup.getContent().size());
        for (LibraryNode node : this.sprintGroup.getContent()) {
            contentNames.add(node.getName());
        }
        return contentNames;
    }
}

